/*
 * Decompiled with CFR 0.152.
 */
package one.devos.nautical.up_and_away.content.balloon.entity.renderer;

import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import one.devos.nautical.up_and_away.UpAndAway;
import one.devos.nautical.up_and_away.content.balloon.entity.AbstractBalloon;
import one.devos.nautical.up_and_away.content.balloon.entity.attachment.BalloonAttachment;
import one.devos.nautical.up_and_away.content.balloon.entity.renderer.BalloonModels;
import one.devos.nautical.up_and_away.content.balloon.entity.renderer.model.AbstractBalloonModel;
import org.joml.Matrix4f;

public class BalloonRenderer
extends class_897<AbstractBalloon> {
    public static final class_2960 TEXTURE = UpAndAway.id("textures/entity/balloon/balloon.png");
    private final BalloonModels models = new BalloonModels(arg_0 -> ((class_5617.class_5618)context).method_32167(arg_0));

    public BalloonRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(AbstractBalloon balloon, float yRot, float partialTicks, class_4587 matrices, class_4597 buffers, int light) {
        super.method_3936((class_1297)balloon, yRot, partialTicks, matrices, buffers, light);
        matrices.method_22903();
        matrices.method_22904(0.0, 1.5, 0.0);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        AbstractBalloonModel model = this.models.choose(balloon.shape());
        class_4588 vertices = buffers.getBuffer(class_1921.method_23580((class_2960)this.getTextureLocation(balloon)));
        model.method_2828(matrices, vertices, light, class_4608.field_21444, balloon.color());
        matrices.method_22909();
        BalloonAttachment attachment = balloon.attachment();
        if (attachment != null) {
            this.renderString(balloon, partialTicks, matrices, buffers, attachment.getPos(partialTicks));
        }
    }

    public class_2960 getTextureLocation(AbstractBalloon balloon) {
        return TEXTURE;
    }

    private void renderString(AbstractBalloon balloon, float partialTicks, class_4587 matrices, class_4597 buffers, class_243 target) {
        int v;
        matrices.method_22903();
        double rot = (double)balloon.method_60951(partialTicks) * (Math.PI / 180) + 1.5707963267948966;
        class_243 relativeStringOffset = balloon.method_45321(partialTicks).method_1031(0.0, 0.0, 1.0E-5);
        double stringOffsetX = Math.cos(rot) * relativeStringOffset.field_1350 + Math.sin(rot) * relativeStringOffset.field_1352;
        double stringOffsetZ = Math.sin(rot) * relativeStringOffset.field_1350 - Math.cos(rot) * relativeStringOffset.field_1352;
        double targetX = class_3532.method_16436((double)partialTicks, (double)balloon.field_6014, (double)balloon.method_23317()) + stringOffsetX;
        double targetY = class_3532.method_16436((double)partialTicks, (double)balloon.field_6036, (double)balloon.method_23318()) + relativeStringOffset.field_1351;
        double targetZ = class_3532.method_16436((double)partialTicks, (double)balloon.field_5969, (double)balloon.method_23321()) + stringOffsetZ;
        matrices.method_22904(stringOffsetX, relativeStringOffset.field_1351, stringOffsetZ);
        float dx = (float)(target.field_1352 - targetX);
        float dy = (float)(target.field_1351 - targetY);
        float dz = (float)(target.field_1350 - targetZ);
        float n = 0.025f;
        class_4588 vertices = buffers.getBuffer(class_1921.method_23587());
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float o = class_3532.method_48119((float)(dx * dx + dz * dz)) * n / 2.0f;
        float p = dz * o;
        float q = dx * o;
        class_2338 blockPos = class_2338.method_49638((class_2374)balloon.method_5836(partialTicks));
        class_2338 blockPos2 = class_2338.method_49638((class_2374)target);
        int r = this.method_24087(balloon, blockPos);
        int s = balloon.method_37908().method_8314(class_1944.field_9282, blockPos);
        int t = balloon.method_37908().method_8314(class_1944.field_9284, blockPos);
        int u = balloon.method_37908().method_8314(class_1944.field_9284, blockPos2);
        for (v = 0; v <= 24; ++v) {
            BalloonRenderer.addVertexPair(vertices, matrix4f, dx, dy, dz, r, s, t, u, n, n, p, q, v, -1, -286331154);
        }
        for (v = 24; v >= 0; --v) {
            BalloonRenderer.addVertexPair(vertices, matrix4f, dx, dy, dz, r, s, t, u, n, 0.0f, p, q, v, -286331154, -1);
        }
        matrices.method_22909();
    }

    private static void addVertexPair(class_4588 vertexConsumer, Matrix4f matrix4f, float dx, float dy, float dz, int i, int j, int k, int l, float m, float n, float o, float p, int index, int colorA, int colorB) {
        float progress = (float)index / 24.0f;
        int s = (int)class_3532.method_16439((float)progress, (float)i, (float)j);
        int t = (int)class_3532.method_16439((float)progress, (float)k, (float)l);
        int u = class_765.method_23687((int)s, (int)t);
        int color = index % 2 == 0 ? colorA : colorB;
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
        float z = dx * progress;
        float aa = dy > 0.0f ? dy * progress * progress : dy - dy * (1.0f - progress) * (1.0f - progress);
        float ab = dz * progress;
        vertexConsumer.method_22918(matrix4f, z - o, aa + n, ab + p).method_22915(r, g, b, 1.0f).method_60803(u);
        vertexConsumer.method_22918(matrix4f, z + o, aa + m - n, ab - p).method_22915(r, g, b, 1.0f).method_60803(u);
    }
}

