/*
 * Decompiled with CFR 0.152.
 */
package one.devos.nautical.up_and_away.framework.item;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_326;
import net.minecraft.class_7923;
import one.devos.nautical.up_and_away.UpAndAway;
import one.devos.nautical.up_and_away.content.balloon.BalloonShape;
import one.devos.nautical.up_and_away.content.balloon.item.BalloonItem;
import org.apache.commons.lang3.Validate;

public record Balloons(Map<BalloonShape, BalloonItem> items) {
    public BalloonItem get(BalloonShape shape) {
        return this.items.get((Object)shape);
    }

    public void forEach(Consumer<BalloonItem> consumer) {
        this.items.values().forEach(consumer);
    }

    public boolean contains(class_1792 item) {
        return item instanceof BalloonItem && this.items.containsValue(item);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String template;
        private final Set<BalloonShape> excluded = EnumSet.noneOf(BalloonShape.class);
        private final Map<BalloonShape, BalloonItem.Factory> factories = new EnumMap<BalloonShape, BalloonItem.Factory>(BalloonShape.class);
        private class_2357 dispenseBehavior;
        private Supplier<Supplier<Object>> renderer;
        private Supplier<Supplier<Object>> colorProvider;

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public Builder factory(BalloonItem.Factory factory) {
            for (BalloonShape shape : BalloonShape.values()) {
                this.factory(shape, factory);
            }
            return this;
        }

        public Builder factory(BalloonShape shape, BalloonItem.Factory factory) {
            this.factories.put(shape, factory);
            return this;
        }

        public Builder exclude(BalloonShape shape) {
            this.excluded.add(shape);
            return this;
        }

        public Builder dispenseBehavior(class_2357 behavior) {
            this.dispenseBehavior = behavior;
            return this;
        }

        public Builder renderer(Supplier<Supplier<Object>> renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder colorProvider(Supplier<Supplier<Object>> colorProvider) {
            this.colorProvider = colorProvider;
            return this;
        }

        public Balloons build() {
            Objects.requireNonNull(this.template, "template");
            Validate.isTrue((!this.factories.isEmpty() ? 1 : 0) != 0, (String)"factories", (Object[])new Object[0]);
            EnumMap<BalloonShape, BalloonItem> items = new EnumMap<BalloonShape, BalloonItem>(BalloonShape.class);
            for (BalloonShape shape : BalloonShape.values()) {
                BalloonItem.Factory factory = this.factories.get((Object)shape);
                if (factory == null || this.excluded.contains((Object)shape)) continue;
                BalloonItem item = factory.create(shape, new class_1792.class_1793());
                items.put(shape, item);
                String name = this.template.formatted(shape.name);
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)UpAndAway.id(name), (Object)((Object)item));
                if (this.dispenseBehavior != null) {
                    class_2315.method_10009((class_1935)item, (class_2357)this.dispenseBehavior);
                }
                if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
                this.buildClient(item);
            }
            return new Balloons(items);
        }

        @Environment(value=EnvType.CLIENT)
        private void buildClient(BalloonItem item) {
            if (this.renderer != null) {
                BuiltinItemRendererRegistry.INSTANCE.register((class_1935)item, (BuiltinItemRendererRegistry.DynamicItemRenderer)this.renderer.get().get());
            }
            if (this.colorProvider != null) {
                ColorProviderRegistry.ITEM.register((Object)((class_326)this.colorProvider.get().get()), (Object[])new class_1935[]{item});
            }
        }
    }
}

