/*
 * Decompiled with CFR 0.152.
 */
package one.devos.nautical.up_and_away.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_4048;
import one.devos.nautical.up_and_away.content.balloon.entity.AbstractBalloon;
import one.devos.nautical.up_and_away.content.balloon.entity.FloatyBalloon;
import one.devos.nautical.up_and_away.content.balloon.entity.attachment.BalloonAttachment;
import one.devos.nautical.up_and_away.content.balloon.entity.attachment.EntityBalloonAttachment;
import one.devos.nautical.up_and_away.framework.entity.SometimesSerializableEntity;
import one.devos.nautical.up_and_away.framework.ext.EntityExt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_1297.class})
public abstract class EntityMixin
implements EntityExt {
    @Unique
    private int floatyBalloons = 0;
    @Unique
    private final List<AbstractBalloon> balloons = new ArrayList<AbstractBalloon>();

    @Shadow
    public abstract class_243 method_19538();

    @ModifyExpressionValue(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;getDimensions()Lnet/minecraft/world/entity/EntityDimensions;")})
    private class_4048 balloonDefaultDimensions(class_4048 dimensions) {
        if (this instanceof AbstractBalloon) {
            return AbstractBalloon.DEFAULT_SHAPE.dimensions;
        }
        return dimensions;
    }

    @ModifyExpressionValue(method={"getEncodeId"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;canSerialize()Z")})
    private boolean sometimesSerializable(boolean original) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof SometimesSerializableEntity) {
            SometimesSerializableEntity entity = (SometimesSerializableEntity)((Object)entityMixin);
            return entity.isSerializable();
        }
        return original;
    }

    @ModifyExpressionValue(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;maybeBackOffFromEdge(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/MoverType;)Lnet/minecraft/world/phys/Vec3;")})
    private class_243 balloonStringCollision(class_243 motion) {
        EntityMixin entityMixin = this;
        if (!(entityMixin instanceof AbstractBalloon)) {
            return motion;
        }
        AbstractBalloon self = (AbstractBalloon)((Object)entityMixin);
        BalloonAttachment attachment = self.attachment();
        if (attachment == null) {
            return motion;
        }
        class_243 pos = this.method_19538();
        class_243 nextPos = pos.method_1019(motion);
        if (!attachment.isTooFar(nextPos)) {
            return motion;
        }
        class_243 attachmentToNext = attachment.getPos().method_1035(nextPos);
        class_243 atMaxLength = attachmentToNext.method_1029().method_1021(attachment.stringLength);
        return pos.method_1035(attachment.getPos().method_1019(atMaxLength));
    }

    @ModifyExpressionValue(method={"getGravity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getDefaultGravity()D")})
    private double lowBalloonGravity(double gravity) {
        if (this.floatyBalloons == 0 || gravity <= -0.04) {
            return gravity;
        }
        double subtracted = (double)this.floatyBalloons * 0.019;
        return Math.max(gravity - subtracted, -0.04);
    }

    @ModifyReturnValue(method={"saveWithoutId"}, at={@At(value="RETURN")})
    private class_2487 saveBalloons(class_2487 nbt) {
        if (this.balloons.isEmpty()) {
            return nbt;
        }
        class_2499 balloonNbtList = new class_2499();
        for (AbstractBalloon balloon : this.balloons) {
            if (!balloon.hasAttachment()) continue;
            class_2487 tag = new class_2487();
            tag.method_10566("attachment", (class_2520)balloon.attachment().toNbt());
            tag.method_10566("entity", (class_2520)balloon.saveWithoutAttachment());
            balloonNbtList.add((Object)tag);
        }
        nbt.method_10566(EntityBalloonAttachment.BALLOONS_KEY, (class_2520)balloonNbtList);
        return nbt;
    }

    @Override
    public void up_and_away$addBalloon(AbstractBalloon balloon) {
        this.balloons.add(balloon);
        if (balloon instanceof FloatyBalloon) {
            ++this.floatyBalloons;
        }
    }

    @Override
    public void up_and_away$removeBalloon(AbstractBalloon balloon) {
        if (this.balloons.remove(balloon) && balloon instanceof FloatyBalloon) {
            --this.floatyBalloons;
        }
    }

    @Override
    public List<AbstractBalloon> up_and_away$getBalloons() {
        return this.balloons;
    }
}

