/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.compat;

import dev.quarris.enigmaticgraves.grave.data.CosmeticArmorReworkedGraveData;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lain.mods.cos.api.CosArmorAPI;
import lain.mods.cos.api.inventory.CAStacksBase;
import lain.mods.cos.impl.ModConfigs;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class CosmeticArmorReworkedCompat {
    public static final Map<UUID, CAStacksBase> CACHED_COSMETICARMORREWORKEDS = new HashMap<UUID, CAStacksBase>();

    public static void cacheCosmeticArmorReworkeds(Player player) {
        if (((Boolean)ModConfigs.CosArmorKeepThroughDeath.get()).booleanValue()) {
            return;
        }
        try {
            RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
            CAStacksBase cached = new CAStacksBase();
            cached.deserializeNBT((HolderLookup.Provider)provider, CosArmorAPI.getCAStacks((UUID)player.getUUID()).serializeNBT((HolderLookup.Provider)provider));
            CACHED_COSMETICARMORREWORKEDS.put(player.getUUID(), cached);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IGraveData generateCosmeticArmorReworkedGraveData(Player player, Collection<ItemEntity> drops) {
        if (CACHED_COSMETICARMORREWORKEDS.containsKey(player.getUUID())) {
            CosmeticArmorReworkedGraveData data = new CosmeticArmorReworkedGraveData(CACHED_COSMETICARMORREWORKEDS.get(player.getUUID()), drops);
            CACHED_COSMETICARMORREWORKEDS.remove(player.getUUID());
            return data;
        }
        return null;
    }
}

