/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.content;

import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.setup.Registry;
import dev.quarris.enigmaticgraves.utils.ClientHelper;
import dev.quarris.enigmaticgraves.utils.ModRef;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class GraveEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(GraveEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.defineId(GraveEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private List<IGraveData> contents = new ArrayList<IGraveData>();
    private boolean restored;

    public static GraveEntity createGrave(Player player, List<IGraveData> graveData) {
        GraveEntity grave = new GraveEntity(player);
        BlockPos.MutableBlockPos spawnPos = new BlockPos.MutableBlockPos();
        boolean spawnBlockBelow = GraveManager.getSpawnPosition(player.level(), player.position(), spawnPos);
        if (spawnBlockBelow) {
            ResourceLocation blockName = ResourceLocation.tryParse((String)((String)GraveConfigs.COMMON.graveFloorBlock.get()));
            BlockState state = ((Block)((Holder.Reference)BuiltInRegistries.BLOCK.getHolder(blockName).get()).value()).defaultBlockState();
            player.level().setBlock(spawnPos.below(), state, 3);
            player.level().levelEvent(2001, (BlockPos)spawnPos, Block.getId((BlockState)state));
        }
        grave.setRot(player.getXRot(), 0.0f);
        grave.setPos((float)spawnPos.getX() + player.getBbWidth() / 2.0f, spawnPos.getY(), (float)spawnPos.getZ() + player.getBbWidth() / 2.0f);
        grave.setContents(graveData);
        return grave;
    }

    public GraveEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public GraveEntity(Player player) {
        this((EntityType)Registry.GRAVE_ENTITY_TYPE.get(), player.level());
        this.setOwner(player);
    }

    public void tick() {
        if (!this.level().isClientSide() && GraveManager.getWorldGraveData((LevelAccessor)this.level()).isGraveRestored(this.getUUID())) {
            this.remove(Entity.RemovalReason.DISCARDED);
            GraveManager.getWorldGraveData((LevelAccessor)this.level()).removeGraveRestored(this.getUUID());
        }
        super.tick();
    }

    public boolean isCurrentlyGlowing() {
        return this.level().isClientSide ? ClientHelper.shouldGlowOnClient(this) : super.isCurrentlyGlowing();
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.empty());
        pBuilder.define(OWNER_NAME, (Object)"");
    }

    public void playerTouch(Player player) {
        if (((Boolean)GraveConfigs.COMMON.sneakRetrieval.get()).booleanValue() && player.isShiftKeyDown() && this.belongsTo(player)) {
            this.restoreGrave(player);
        }
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack heldItem;
        if (this.belongsTo(player)) {
            this.restoreGrave(player);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (player.isCreative() && (heldItem = player.getItemInHand(hand)).getItem() == Registry.GRAVE_FINDER_ITEM.get() && !heldItem.has(DataComponents.CUSTOM_DATA)) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return InteractionResult.PASS;
    }

    private void restoreGrave(Player player) {
        if (!this.isAlive() || this.level().isClientSide()) {
            return;
        }
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            CompoundTag nbt;
            ItemStack stack = player.getInventory().getItem(slot);
            if (stack.getItem() != Registry.GRAVE_FINDER_ITEM.get() || (nbt = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag()) == null || !nbt.getUUID("GraveUUID").equals(this.getUUID())) continue;
            player.getInventory().setItem(slot, ItemStack.EMPTY);
            break;
        }
        for (IGraveData data : this.contents) {
            data.restore(player);
        }
        GraveManager.setGraveRestored(this.getOwnerUUID(), this);
        this.restored = true;
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (!this.level().isClientSide && !this.restored) {
            ModRef.LOGGER.warn("Grave at {} was removed without being restored!", (Object)this.blockPosition());
        }
    }

    private boolean belongsTo(Player player) {
        return player.getUUID().equals(this.getOwnerUUID());
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        CompoundTag graveNBT = new CompoundTag();
        ListTag contentNBT = new ListTag();
        RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
        for (IGraveData data : this.contents) {
            contentNBT.add((Object)data.serializeNBT((HolderLookup.Provider)provider));
        }
        graveNBT.put("Content", (Tag)contentNBT);
        if (this.getOwnerUUID() != null) {
            graveNBT.putUUID("Owner", this.getOwnerUUID());
        }
        if (!this.getOwnerName().isEmpty()) {
            graveNBT.putString("OwnerName", this.getOwnerName());
        }
        compound.put("Grave", (Tag)graveNBT);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        CompoundTag graveNBT = compound.getCompound("Grave");
        ArrayList<IGraveData> dataList = new ArrayList<IGraveData>();
        ListTag contentNBT = graveNBT.getList("Content", 10);
        for (Tag inbt : contentNBT) {
            CompoundTag dataNBT = (CompoundTag)inbt;
            ResourceLocation name = ResourceLocation.tryParse((String)dataNBT.getString("Name"));
            IGraveData data = GraveManager.GRAVE_DATA_SUPPLIERS.get(name).apply(dataNBT);
            dataList.add(data);
        }
        this.setContents(dataList);
        if (graveNBT.contains("Owner")) {
            this.entityData.set(OWNER, Optional.of(graveNBT.getUUID("Owner")));
        }
        if (graveNBT.contains("OwnerName")) {
            this.entityData.set(OWNER_NAME, (Object)graveNBT.getString("OwnerName"));
        }
    }

    public void setContents(List<IGraveData> contents) {
        this.contents = contents;
    }

    public void setOwner(Player owner) {
        this.entityData.set(OWNER, Optional.of(owner.getUUID()));
        this.entityData.set(OWNER_NAME, (Object)owner.getName().getString());
    }

    public String getOwnerName() {
        return (String)this.entityData.get(OWNER_NAME);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER)).orElse(null);
    }

    public boolean isPickable() {
        return true;
    }
}

