/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.content;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class GraveFinderItem
extends Item {
    public GraveFinderItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag flagIn) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            tooltip.add((Component)Component.translatable((String)"info.grave.remove_grave"));
            return;
        }
        CompoundTag nbt = data.copyTag();
        if (nbt.contains("Pos")) {
            BlockPos bp = (BlockPos)NbtUtils.readBlockPos((CompoundTag)nbt, (String)"Pos").get();
            tooltip.add((Component)Component.literal((String)("X: " + bp.getX() + ", Y: " + bp.getY() + ", Z: " + bp.getZ())));
        } else {
            tooltip.add((Component)Component.translatable((String)"info.grave.not_found"));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isShiftKeyDown() || !player.isCreative()) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!stack.has(DataComponents.CUSTOM_DATA) || !((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().contains("Pos")) {
            return InteractionResultHolder.pass((Object)stack);
        }
        player.startUsingItem(hand);
        if (level instanceof ServerLevel) {
            BlockPos pos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag(), (String)"Pos").get();
            MutableComponent result = ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()})).withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.getX() + " " + pos.getY() + " " + pos.getZ())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip"))));
            player.displayClientMessage((Component)Component.translatable((String)"grave.locate", (Object[])new Object[]{result}), false);
            player.swing(hand, true);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.consume((Object)stack);
    }
}

