/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.content;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;

public class GraveModel
extends EntityModel<Entity> {
    private final ModelPart pot;
    private final ModelPart sapling_r1;
    private final ModelPart sapling_r2;
    private final ModelPart grave;

    public GraveModel(ModelPart model) {
        this.pot = model.getChild("pot");
        this.sapling_r1 = this.pot.getChild("sapling_r1");
        this.sapling_r2 = this.pot.getChild("sapling_r2");
        this.grave = model.getChild("grave");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition pot = root.addOrReplaceChild("pot", CubeListBuilder.create().texOffs(23, 38).addBox(-3.0f, 2.0f, 4.0f, 3.0f, 3.0f, 1.0f).texOffs(0, 4).addBox(-4.0f, 2.0f, 1.0f, 1.0f, 3.0f, 3.0f).texOffs(0, 0).addBox(-3.0f, 1.0f, 1.0f, 3.0f, 1.0f, 3.0f).texOffs(16, 33).addBox(0.0f, 2.0f, 1.0f, 1.0f, 3.0f, 3.0f).texOffs(39, 29).addBox(-3.0f, 2.0f, 0.0f, 3.0f, 3.0f, 1.0f).texOffs(19, 42).addBox(-3.0f, 3.0f, 1.0f, 3.0f, 1.0f, 3.0f), PartPose.offset((float)-1.0f, (float)26.0f, (float)0.0f));
        PartDefinition sapling_r1 = pot.addOrReplaceChild("sapling_r1", CubeListBuilder.create().texOffs(0, 33).addBox(-4.0f, 7.0f, 0.0f, 8.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)-1.5f, (float)-4.5f, (float)2.5f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition sapling_r2 = pot.addOrReplaceChild("sapling_r2", CubeListBuilder.create().texOffs(0, 33).addBox(-4.0f, 7.0f, 0.0f, 8.0f, 8.0f, 0.0f), PartPose.offsetAndRotation((float)-1.5f, (float)-4.5f, (float)2.5f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition grave = root.addOrReplaceChild("grave", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -1.0f, -5.0f, 14.0f, 1.0f, 12.0f).texOffs(0, 13).addBox(-7.0f, -1.0f, -7.0f, 14.0f, 14.0f, 2.0f).texOffs(32, 13).addBox(-8.0f, -1.0f, -7.5f, 1.0f, 14.0f, 3.0f).texOffs(0, 29).addBox(-7.0f, 13.0f, -7.5f, 14.0f, 1.0f, 3.0f).texOffs(31, 30).addBox(7.0f, -1.0f, -7.5f, 1.0f, 14.0f, 3.0f).texOffs(0, 52).addBox(-6.0f, 0.0f, -5.0f, 12.0f, 1.0f, 11.0f), PartPose.offset((float)0.0f, (float)26.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int pColor) {
        matrixStack.pushPose();
        matrixStack.mulPose(new Quaternionf(new AxisAngle4d(180.0, 0.0, 1.0, 0.0)));
        matrixStack.translate(0.0, -1.5, 0.0);
        this.pot.render(matrixStack, buffer, packedLight, packedOverlay);
        this.grave.render(matrixStack, buffer, packedLight, packedOverlay);
        matrixStack.popPose();
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

