/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave;

import dev.quarris.enigmaticgraves.compat.CompatManager;
import dev.quarris.enigmaticgraves.compat.CosmeticArmorReworkedCompat;
import dev.quarris.enigmaticgraves.compat.CurioCompat;
import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.content.GraveEntity;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.grave.WorldGraveData;
import dev.quarris.enigmaticgraves.grave.data.CosmeticArmorReworkedGraveData;
import dev.quarris.enigmaticgraves.grave.data.CurioGraveData;
import dev.quarris.enigmaticgraves.grave.data.ExperienceGraveData;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.grave.data.PlayerInventoryGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class GraveManager {
    public static final HashMap<ResourceLocation, Function<CompoundTag, IGraveData>> GRAVE_DATA_SUPPLIERS = new HashMap();
    public static PlayerGraveEntry latestGraveEntry;
    public static final DateFormat TIMESTAMP_FORMAT;

    public static void init() {
        GRAVE_DATA_SUPPLIERS.put(PlayerInventoryGraveData.NAME, PlayerInventoryGraveData::new);
        GRAVE_DATA_SUPPLIERS.put(ExperienceGraveData.NAME, ExperienceGraveData::new);
        if (CompatManager.isCuriosLoaded()) {
            GRAVE_DATA_SUPPLIERS.put(CurioGraveData.NAME, CurioGraveData::new);
        }
        if (CompatManager.isCosmeticArmorReworkedLoaded()) {
            GRAVE_DATA_SUPPLIERS.put(CosmeticArmorReworkedGraveData.NAME, CosmeticArmorReworkedGraveData::new);
        }
    }

    public static WorldGraveData getWorldGraveData(LevelAccessor world) {
        if (world instanceof ServerLevel) {
            MinecraftServer server = ((ServerLevel)world).getServer();
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            return (WorldGraveData)overworld.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldGraveData::new, WorldGraveData::load), "enigmaticgraves");
        }
        return null;
    }

    public static boolean shouldSpawnGrave(Player player) {
        return !player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) && !player.isSpectator();
    }

    public static void prepPlayerGrave(Player player) {
        if (!GraveManager.shouldSpawnGrave(player)) {
            ModRef.LOGGER.info("Cannot spawn grave. Player is spectator is the KEEP_INVENTORY gamerule is enabled");
            return;
        }
        ModRef.LOGGER.info("Preparing grave for " + player.getName().getString());
        PlayerGraveEntry entry = new PlayerGraveEntry(player.getInventory());
        CompatManager.cacheModdedHandlers(player);
        latestGraveEntry = entry;
    }

    public static void populatePlayerGrave(Player player, Collection<ItemEntity> drops) {
        if (latestGraveEntry == null) {
            return;
        }
        ModRef.LOGGER.debug("Populating grave for " + player.getName().getString());
        GraveManager.generateGraveDataList(player, latestGraveEntry, drops);
    }

    public static void spawnPlayerGrave(Player player) {
        if (latestGraveEntry == null) {
            return;
        }
        WorldGraveData worldData = GraveManager.getWorldGraveData((LevelAccessor)player.level());
        GraveEntity grave = GraveEntity.createGrave(player, GraveManager.latestGraveEntry.dataList);
        ModRef.LOGGER.debug("Attempting to spawn grave for " + player.getName().getString() + " at " + String.valueOf(grave.blockPosition()));
        GraveManager.latestGraveEntry.graveUUID = grave.getUUID();
        GraveManager.latestGraveEntry.gravePos = grave.blockPosition();
        if (!player.level().addFreshEntity((Entity)grave)) {
            ModRef.LOGGER.warn("Could not spawn grave for " + player.getName().getString());
        } else {
            ModRef.LOGGER.info("Spawned grave for " + player.getName().getString() + " at " + String.valueOf(grave.blockPosition()));
        }
        worldData.addGraveEntry(player, latestGraveEntry);
        ModRef.LOGGER.info("Added grave entry to player " + player.getName().getString());
        latestGraveEntry = null;
    }

    public static void generateGraveDataList(Player player, PlayerGraveEntry entry, Collection<ItemEntity> drops) {
        IGraveData cosmeticArmorReworkedsData;
        IGraveData curiosData;
        ArrayList<IGraveData> dataList = new ArrayList<IGraveData>();
        PlayerInventoryGraveData playerInvData = new PlayerInventoryGraveData(entry.inventory, drops);
        dataList.add(playerInvData);
        GraveConfigs.Common.ExperienceHandling xpHandling = (GraveConfigs.Common.ExperienceHandling)((Object)GraveConfigs.COMMON.experienceGraveHandling.get());
        if (xpHandling != GraveConfigs.Common.ExperienceHandling.DROP) {
            int xp = 0;
            if (xpHandling == GraveConfigs.Common.ExperienceHandling.KEEP_VANILLA) {
                xp = player.getExperienceReward((ServerLevel)player.level(), null);
                xp = EventHooks.getExperienceDrop((LivingEntity)player, (Player)player, (int)xp);
            } else if (xpHandling == GraveConfigs.Common.ExperienceHandling.KEEP_ALL) {
                xp += (int)(player.experienceProgress * (float)player.getXpNeededForNextLevel());
                while (player.experienceLevel > 0) {
                    --player.experienceLevel;
                    xp += player.getXpNeededForNextLevel();
                }
            }
            ExperienceGraveData xpData = new ExperienceGraveData(xp);
            dataList.add(xpData);
        }
        if (CompatManager.isCuriosLoaded() && (curiosData = CurioCompat.generateCurioGraveData(player, drops)) != null) {
            dataList.add(curiosData);
        }
        if (CompatManager.isCosmeticArmorReworkedLoaded() && (cosmeticArmorReworkedsData = CosmeticArmorReworkedCompat.generateCosmeticArmorReworkedGraveData(player, drops)) != null) {
            dataList.add(cosmeticArmorReworkedsData);
        }
        playerInvData.addRemaining(drops);
        entry.dataList = dataList;
    }

    public static void setGraveRestored(UUID player, GraveEntity grave) {
        LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((LevelAccessor)grave.level()).getGraveEntriesForPlayer(player);
        if (entries != null) {
            entries.stream().filter(entry -> entry.graveUUID.equals(grave.getUUID())).findFirst().ifPresent(PlayerGraveEntry::setRestored);
        }
    }

    public static boolean getSpawnPosition(Level world, Vec3 deathPos, BlockPos.MutableBlockPos outPos) {
        GraveConfigs.Common configs = GraveConfigs.COMMON;
        BlockPos.MutableBlockPos pos = new BlockPos((int)deathPos.x, (int)Math.round(deathPos.y), (int)deathPos.z).mutable();
        while (pos.getY() > world.getMinBuildHeight()) {
            BlockPos belowPos = new BlockPos((Vec3i)pos).below();
            BlockState belowState = world.getBlockState(belowPos);
            if (GraveManager.blocksMovement(belowState)) {
                outPos.set((Vec3i)pos);
                return false;
            }
            pos = pos.move(Direction.DOWN);
        }
        pos = new BlockPos((int)deathPos.x, ((Integer)configs.scanHeight.get()).intValue(), (int)deathPos.z);
        for (int scan = 0; scan < (Integer)configs.scanRange.get(); ++scan) {
            BlockPos scanPos = new BlockPos((Vec3i)pos).above(scan);
            if (!GraveManager.blocksMovement(world.getBlockState(scanPos.above())) && !GraveManager.blocksMovement(world.getBlockState(scanPos)) && GraveManager.blocksMovement(world.getBlockState(scanPos.below()))) {
                outPos.set((Vec3i)scanPos);
                return false;
            }
            if (scan <= 0 || GraveManager.blocksMovement(world.getBlockState((scanPos = new BlockPos((Vec3i)pos).below(scan)).above())) || GraveManager.blocksMovement(world.getBlockState(scanPos)) || !GraveManager.blocksMovement(world.getBlockState(scanPos.below()))) continue;
            outPos.set((Vec3i)scanPos);
            return false;
        }
        if (!GraveManager.blocksMovement(world.getBlockState((BlockPos)pos)) && !GraveManager.blocksMovement(world.getBlockState(pos.above()))) {
            outPos.set((Vec3i)pos);
            return true;
        }
        outPos.set(deathPos.x, (double)(world.getMinBuildHeight() + 1), deathPos.z);
        return !world.getBlockState(new BlockPos((int)deathPos.x, 0, (int)deathPos.z)).blocksMotion();
    }

    private static boolean blocksMovement(BlockState state) {
        return state.blocksMotion();
    }

    static {
        TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
    }
}

