/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave;

import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class PlayerGraveEntry
implements INBTSerializable<CompoundTag> {
    public Inventory inventory;
    public UUID graveUUID;
    public BlockPos gravePos;
    public Date timestamp;
    public List<IGraveData> dataList = new ArrayList<IGraveData>();
    private boolean restored;

    public PlayerGraveEntry(Inventory inventory) {
        this.inventory = new Inventory(inventory.player);
        this.inventory.replaceWith(inventory);
        this.timestamp = new Date();
    }

    public PlayerGraveEntry(HolderLookup.Provider provider, CompoundTag nbt) {
        this.dataList = new ArrayList<IGraveData>();
        this.deserializeNBT(provider, nbt);
    }

    public String getEntryName(int id) {
        return String.format("death_%d_%s", id, GraveManager.TIMESTAMP_FORMAT.format(this.timestamp));
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putUUID("Grave", this.graveUUID);
        nbt.put("Pos", NbtUtils.writeBlockPos((BlockPos)this.gravePos));
        nbt.putLong("Timestamp", this.timestamp.getTime());
        ListTag dataNBT = new ListTag();
        for (IGraveData data : this.dataList) {
            dataNBT.add((Object)data.serializeNBT(provider));
        }
        nbt.put("Data", (Tag)dataNBT);
        nbt.putBoolean("Restored", this.restored);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.graveUUID = nbt.getUUID("Grave");
        this.gravePos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)nbt, (String)"Pos").get();
        this.timestamp = new Date(nbt.getLong("Timestamp"));
        ListTag dataNBT = nbt.getList("Data", 10);
        for (Tag inbt : dataNBT) {
            CompoundTag graveNBT = (CompoundTag)inbt;
            ResourceLocation name = ResourceLocation.tryParse((String)graveNBT.getString("Name"));
            IGraveData data = GraveManager.GRAVE_DATA_SUPPLIERS.get(name).apply(graveNBT);
            this.dataList.add(data);
        }
        this.restored = nbt.getBoolean("Restored");
    }

    public void setRestored() {
        this.restored = true;
    }

    public boolean isRestored() {
        return this.restored;
    }
}

