/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave;

import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.utils.ModRef;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldGraveData
extends SavedData {
    public static final String NAME = "enigmaticgraves";
    private final Map<UUID, LinkedList<PlayerGraveEntry>> playerGraveEntries = new HashMap<UUID, LinkedList<PlayerGraveEntry>>();
    private final Set<UUID> restoredGraves = new HashSet<UUID>();

    public LinkedList<PlayerGraveEntry> getGraveEntriesForPlayer(UUID playerUUID) {
        return this.playerGraveEntries.get(playerUUID);
    }

    public void setGraveRestored(UUID graveUUID) {
        this.restoredGraves.add(graveUUID);
        this.setDirty();
    }

    public void removeGraveRestored(UUID graveUUID) {
        this.restoredGraves.remove(graveUUID);
        this.setDirty();
    }

    public boolean isGraveRestored(UUID graveUUID) {
        return this.restoredGraves.contains(graveUUID);
    }

    public void addGraveEntry(Player player, PlayerGraveEntry entry) {
        LinkedList entries = this.playerGraveEntries.computeIfAbsent(player.getUUID(), k -> new LinkedList());
        if (entries.size() >= (Integer)GraveConfigs.COMMON.graveEntryCount.get()) {
            ModRef.LOGGER.debug("Entries reached max values for " + String.valueOf(player.getName()));
            ModRef.LOGGER.debug("Removing oldest entry");
            entries.removeLast();
        }
        entries.addFirst(entry);
        this.setDirty();
    }

    public void clearGraveEntries(Player player) {
        this.playerGraveEntries.remove(player.getUUID());
        this.setDirty();
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        ListTag playerGraveEntriesNBT = new ListTag();
        for (UUID uuid : this.playerGraveEntries.keySet()) {
            CompoundTag playerGravesNBT = new CompoundTag();
            playerGravesNBT.putUUID("UUID", uuid);
            List entries = this.playerGraveEntries.get(uuid);
            ListTag entriesNBT = new ListTag();
            for (PlayerGraveEntry entry : entries) {
                entriesNBT.add((Object)entry.serializeNBT(provider));
            }
            playerGravesNBT.put("Entries", (Tag)entriesNBT);
            playerGraveEntriesNBT.add((Object)playerGravesNBT);
        }
        compound.put("PlayerGraveEntries", (Tag)playerGraveEntriesNBT);
        ListTag restoredGravesNBT = new ListTag();
        for (UUID restoredGraveUUID : this.restoredGraves) {
            restoredGravesNBT.add((Object)NbtUtils.createUUID((UUID)restoredGraveUUID));
        }
        compound.put("RestoredGraves", (Tag)restoredGravesNBT);
        return compound;
    }

    public static WorldGraveData load(CompoundTag tag, HolderLookup.Provider provider) {
        WorldGraveData data = new WorldGraveData();
        data.loadInternal(tag, provider);
        return data;
    }

    public void loadInternal(CompoundTag nbt, HolderLookup.Provider provider) {
        this.playerGraveEntries.clear();
        this.restoredGraves.clear();
        ListTag playerGraveEntriesNBT = nbt.getList("PlayerGraveEntries", 10);
        for (Tag inbt : playerGraveEntriesNBT) {
            CompoundTag playerGravesNBT = (CompoundTag)inbt;
            UUID uuid = playerGravesNBT.getUUID("UUID");
            ListTag entriesNBT = playerGravesNBT.getList("Entries", 10);
            LinkedList entries = this.playerGraveEntries.computeIfAbsent(uuid, k -> new LinkedList());
            for (int i = 0; i < entriesNBT.size(); ++i) {
                CompoundTag entryNBT = entriesNBT.getCompound(i);
                PlayerGraveEntry entry = new PlayerGraveEntry(provider, entryNBT);
                entries.addLast(entry);
            }
        }
        ListTag restoredGravesNBT = nbt.getList("RestoredGraves", 10);
        for (Tag uuidNBT : restoredGravesNBT) {
            UUID restoredGraveUUID = NbtUtils.loadUUID((Tag)uuidNBT);
            this.restoredGraves.add(restoredGraveUUID);
        }
    }
}

