/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave.data;

import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import dev.quarris.enigmaticgraves.utils.PlayerInventoryExtensions;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import lain.mods.cos.api.CosArmorAPI;
import lain.mods.cos.api.inventory.CAStacksBase;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class CosmeticArmorReworkedGraveData
implements IGraveData {
    public static final ResourceLocation NAME = ModRef.res("cosmeticarmorreworked");
    public final CAStacksBase caStacksBase = new CAStacksBase();

    public CosmeticArmorReworkedGraveData(CAStacksBase caStacksBase, Collection<ItemEntity> drops) {
        RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
        this.caStacksBase.deserializeNBT((HolderLookup.Provider)provider, caStacksBase.serializeNBT((HolderLookup.Provider)provider));
        Iterator<ItemEntity> ite = drops.iterator();
        while (ite.hasNext()) {
            ItemStack drop = ite.next().getItem();
            for (int slot = 0; slot < caStacksBase.getSlots(); ++slot) {
                ItemStack stack = caStacksBase.getStackInSlot(slot);
                if (!ItemStack.matches((ItemStack)stack, (ItemStack)drop)) continue;
                ite.remove();
            }
        }
    }

    public CosmeticArmorReworkedGraveData(CompoundTag nbt) {
        RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
        this.deserializeNBT((HolderLookup.Provider)provider, nbt);
    }

    @Override
    public void restore(Player player) {
        CAStacksBase lowPrio = CosArmorAPI.getCAStacks((UUID)player.getUUID());
        for (int slot = 0; slot < lowPrio.getSlots(); ++slot) {
            ItemStack lowPrioItem = lowPrio.getStackInSlot(slot);
            ItemStack highPrioItem = this.caStacksBase.getStackInSlot(slot);
            if (!lowPrioItem.isEmpty() && !highPrioItem.isEmpty()) {
                PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, -1, lowPrioItem);
                continue;
            }
            if (lowPrioItem.isEmpty()) continue;
            this.caStacksBase.setStackInSlot(slot, lowPrioItem);
        }
        RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
        lowPrio.deserializeNBT((HolderLookup.Provider)provider, this.caStacksBase.serializeNBT((HolderLookup.Provider)provider));
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public CompoundTag write(HolderLookup.Provider provider, CompoundTag nbt) {
        nbt.put("caStacksBase", (Tag)this.caStacksBase.serializeNBT(provider));
        return nbt;
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag nbt) {
        this.caStacksBase.deserializeNBT(provider, nbt.getCompound("caStacksBase"));
    }
}

