/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave.data;

import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import dev.quarris.enigmaticgraves.utils.PlayerInventoryExtensions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.capability.CurioInventoryCapability;

public class CurioGraveData
implements IGraveData {
    public static final ResourceLocation NAME = ModRef.res("curios");
    private ListTag data;

    public CurioGraveData(ListTag curios, Collection<ItemEntity> drops, Player player) {
        this.data = curios.copy();
        CurioInventoryCapability cur = new CurioInventoryCapability((LivingEntity)player);
        cur.loadInventory(curios);
        for (Map.Entry entry : cur.getCurios().entrySet()) {
            ICurioStacksHandler curioItems = (ICurioStacksHandler)entry.getValue();
            NonNullList curioStacksList = NonNullList.withSize((int)curioItems.getSlots(), (Object)ItemStack.EMPTY);
            NonNullList curioCosmeticStacksList = NonNullList.withSize((int)curioItems.getSlots(), (Object)ItemStack.EMPTY);
            Iterator<ItemEntity> ite = drops.iterator();
            HashSet<Integer> stackSlotsChecked = new HashSet<Integer>();
            HashSet<Integer> cosmeticStacksSlotsChecked = new HashSet<Integer>();
            block1: while (ite.hasNext()) {
                ItemStack stack;
                int slot;
                ItemStack drop = ite.next().getItem();
                for (slot = 0; slot < curioItems.getSlots(); ++slot) {
                    if (stackSlotsChecked.contains(slot) || !ItemStack.matches((ItemStack)(stack = curioItems.getStacks().getStackInSlot(slot)), (ItemStack)drop)) continue;
                    stackSlotsChecked.add(slot);
                    curioStacksList.set(slot, (Object)drop);
                    ite.remove();
                    curioItems.getStacks().setStackInSlot(slot, ItemStack.EMPTY);
                    continue block1;
                }
                for (slot = 0; slot < curioItems.getSlots(); ++slot) {
                    if (cosmeticStacksSlotsChecked.contains(slot) || !ItemStack.matches((ItemStack)(stack = curioItems.getCosmeticStacks().getStackInSlot(slot)), (ItemStack)drop)) continue;
                    cosmeticStacksSlotsChecked.add(slot);
                    curioCosmeticStacksList.set(slot, (Object)drop);
                    ite.remove();
                    curioItems.getStacks().setStackInSlot(slot, ItemStack.EMPTY);
                    continue block1;
                }
            }
        }
    }

    public CurioGraveData(CompoundTag nbt) {
        RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
        this.deserializeNBT((HolderLookup.Provider)provider, nbt);
    }

    @Override
    public void restore(Player player) {
        if (this.data == null) {
            return;
        }
        Optional optional = CuriosApi.getCuriosInventory((LivingEntity)player);
        optional.ifPresent(handler -> {
            handler.getCurios().values().forEach(curio -> {
                IDynamicStackHandler stacks = curio.getStacks();
                for (int slot = 0; slot < stacks.getSlots(); ++slot) {
                    ItemStack stack = stacks.getStackInSlot(slot);
                    if (stack.isEmpty()) continue;
                    PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, -1, stack);
                }
            });
            handler.loadInventory(this.data);
        });
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public CompoundTag write(HolderLookup.Provider provider, CompoundTag nbt) {
        if (this.data != null) {
            nbt.put("Data", (Tag)this.data);
        }
        return nbt;
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains("Data")) {
            this.data = (ListTag)nbt.get("Data");
        }
    }
}

