/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.grave.data;

import dev.quarris.enigmaticgraves.grave.data.IGraveData;
import dev.quarris.enigmaticgraves.utils.ModRef;
import dev.quarris.enigmaticgraves.utils.PlayerInventoryExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PlayerInventoryGraveData
implements IGraveData {
    public static final ResourceLocation NAME = ModRef.res("player_inventory");
    private ListTag data;
    private List<ItemStack> remainingItems = new ArrayList<ItemStack>();

    public PlayerInventoryGraveData(Inventory inventory, Collection<ItemEntity> drops) {
        ItemStack stack;
        int slot;
        Inventory graveInv = new Inventory(inventory.player);
        graveInv.replaceWith(inventory);
        block0: for (slot = 0; slot < graveInv.getContainerSize(); ++slot) {
            stack = graveInv.getItem(slot);
            Iterator<ItemEntity> ite = drops.iterator();
            while (ite.hasNext()) {
                ItemStack drop = ite.next().getItem();
                if (!ItemStack.matches((ItemStack)stack, (ItemStack)drop)) continue;
                ite.remove();
                continue block0;
            }
            graveInv.removeItemNoUpdate(slot);
        }
        for (slot = 0; slot < graveInv.armor.size(); ++slot) {
            stack = (ItemStack)graveInv.armor.get(slot);
            if (!EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            if (!PlayerInventoryExtensions.addItemToPlayerInventory(graveInv, -1, stack)) {
                this.remainingItems.add(stack);
            }
            graveInv.armor.set(slot, (Object)ItemStack.EMPTY);
        }
        this.data = graveInv.save(new ListTag());
    }

    public PlayerInventoryGraveData(CompoundTag nbt) {
        RegistryAccess.Frozen provider = ServerLifecycleHooks.getCurrentServer().registryAccess();
        this.deserializeNBT((HolderLookup.Provider)provider, nbt);
    }

    public void addRemaining(Collection<ItemEntity> remaining) {
        this.remainingItems.addAll(remaining.stream().map(ItemEntity::getItem).toList());
    }

    @Override
    public void restore(Player player) {
        Inventory highPriority = new Inventory(player);
        highPriority.load(this.data);
        Inventory lowPriority = new Inventory(player);
        lowPriority.replaceWith(player.getInventory());
        player.getInventory().replaceWith(highPriority);
        for (int slot = 0; slot < lowPriority.getContainerSize(); ++slot) {
            ItemStack item = lowPriority.getItem(slot);
            if (item.isEmpty()) continue;
            PlayerInventoryExtensions.tryAddItemToPlayerInvElseDrop(player, slot, item);
        }
        for (ItemStack remainingStack : this.remainingItems) {
            if (player.getInventory().add(remainingStack)) continue;
            player.spawnAtLocation(remainingStack);
        }
    }

    @Override
    public CompoundTag write(HolderLookup.Provider provider, CompoundTag nbt) {
        nbt.put("Data", (Tag)this.data);
        if (this.remainingItems != null) {
            nbt.putInt("RemainingSize", this.remainingItems.size());
            NonNullList items = NonNullList.of((Object)ItemStack.EMPTY, (Object[])this.remainingItems.toArray(new ItemStack[this.remainingItems.size()]));
            nbt.put("Remaining", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), (NonNullList)items, (HolderLookup.Provider)provider));
        }
        return nbt;
    }

    @Override
    public void read(HolderLookup.Provider provider, CompoundTag nbt) {
        this.data = nbt.getList("Data", 10);
        if (nbt.contains("Remaining")) {
            int size = nbt.getInt("RemainingSize");
            NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("Remaining"), (NonNullList)items, (HolderLookup.Provider)provider);
            this.remainingItems.addAll((Collection<ItemStack>)items);
        }
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

