/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.setup;

import com.mojang.brigadier.CommandDispatcher;
import dev.quarris.enigmaticgraves.command.RestoreGraveCommand;
import dev.quarris.enigmaticgraves.config.GraveConfigs;
import dev.quarris.enigmaticgraves.grave.GraveManager;
import dev.quarris.enigmaticgraves.grave.PlayerGraveEntry;
import dev.quarris.enigmaticgraves.setup.Registry;
import java.util.LinkedList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="enigmaticgraves")
public class CommonEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeathLast(LivingDeathEvent event) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (!event.getEntity().level().isClientSide && !event.isCanceled()) break block3;
            }
            return;
        }
        GraveManager.prepPlayerGrave(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerDrops(LivingDropsEvent event) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (!event.getEntity().level().isClientSide) break block3;
            }
            return;
        }
        GraveManager.populatePlayerGrave(player, event.getDrops());
        GraveManager.spawnPlayerGrave(player);
    }

    @SubscribeEvent
    public static void spawnGraveFinder(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        if (!((Boolean)GraveConfigs.COMMON.spawnGraveFinder.get()).booleanValue()) {
            return;
        }
        ItemStack graveFinder = new ItemStack((ItemLike)Registry.GRAVE_FINDER_ITEM.get());
        LinkedList<PlayerGraveEntry> entries = GraveManager.getWorldGraveData((LevelAccessor)event.getEntity().level()).getGraveEntriesForPlayer(event.getEntity().getUUID());
        if (entries == null || entries.isEmpty()) {
            return;
        }
        PlayerGraveEntry latestEntry = entries.getFirst();
        CompoundTag nbt = new CompoundTag();
        nbt.put("Pos", NbtUtils.writeBlockPos((BlockPos)latestEntry.gravePos));
        nbt.putUUID("GraveUUID", latestEntry.graveUUID);
        graveFinder.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
        event.getEntity().addItem(graveFinder);
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        RestoreGraveCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

