/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.utils;

import dev.quarris.enigmaticgraves.content.GraveEntity;
import dev.quarris.enigmaticgraves.setup.Registry;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class ClientHelper {
    public static boolean shouldGlowOnClient(GraveEntity grave) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack stack = null;
        if (player.getMainHandItem().getItem() == Registry.GRAVE_FINDER_ITEM.get()) {
            stack = player.getMainHandItem();
        }
        if (stack == null && player.getOffhandItem().getItem() == Registry.GRAVE_FINDER_ITEM.get()) {
            stack = player.getOffhandItem();
        }
        if (stack == null) {
            return false;
        }
        CompoundTag nbt = ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag();
        boolean hasTag = nbt.contains("GraveUUID");
        UUID graveUUID = hasTag ? nbt.getUUID("GraveUUID") : null;
        return player.isCreative() || player.isSpectator() || player.getUUID().equals(grave.getOwnerUUID()) && grave.getUUID().equals(graveUUID);
    }
}

