/*
 * Decompiled with CFR 0.152.
 */
package dev.quarris.enigmaticgraves.utils;

import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerInventoryExtensions {
    public static void tryAddItemToPlayerInvElseDrop(Player player, int slot, ItemStack stack) {
        if (!PlayerInventoryExtensions.addItemToPlayerInventory(player.getInventory(), slot, stack)) {
            ItemEntity itemEntity = player.spawnAtLocation(stack);
            itemEntity.setDeltaMovement(0.0, 0.0, 0.0);
            itemEntity.hasImpulse = true;
        }
    }

    public static boolean addItemToPlayerInventory(Inventory inventory, int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (slot == -1 && (slot = inventory.getFreeSlot()) == -1) {
            return false;
        }
        int leftOver = PlayerInventoryExtensions.addResource(inventory, slot, stack);
        stack.setCount(leftOver);
        if (leftOver > 0) {
            PlayerInventoryExtensions.addItemToPlayerInventory(inventory, -1, stack);
        }
        return stack.isEmpty();
    }

    private static int addResource(Inventory inventory, int slot, ItemStack stack) {
        int count;
        ItemStack itemstack = inventory.getItem(slot);
        if (!(itemstack.isEmpty() || ItemStack.matches((ItemStack)stack, (ItemStack)itemstack) && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack))) {
            return stack.getCount();
        }
        if (itemstack.isEmpty()) {
            itemstack = stack.copy();
            itemstack.setCount(0);
            inventory.setItem(slot, itemstack);
        }
        int amountToInsert = count = stack.getCount();
        if (count > itemstack.getMaxStackSize() - itemstack.getCount()) {
            amountToInsert = itemstack.getMaxStackSize() - itemstack.getCount();
        }
        if (amountToInsert > inventory.getMaxStackSize() - itemstack.getCount()) {
            amountToInsert = inventory.getMaxStackSize() - itemstack.getCount();
        }
        if (amountToInsert != 0) {
            count -= amountToInsert;
            itemstack.grow(amountToInsert);
            itemstack.setPopTime(5);
        }
        return count;
    }
}

