/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns;

import com.imguns.guns.GunModComponents;
import com.imguns.guns.api.resource.ResourceManager;
import com.imguns.guns.config.ClientConfig;
import com.imguns.guns.config.CommonConfig;
import com.imguns.guns.config.ServerConfig;
import com.imguns.guns.init.CommandRegistry;
import com.imguns.guns.init.CommonRegistry;
import com.imguns.guns.init.CompatRegistry;
import com.imguns.guns.init.ModBlocks;
import com.imguns.guns.init.ModContainer;
import com.imguns.guns.init.ModCreativeTabs;
import com.imguns.guns.init.ModDamageTypes;
import com.imguns.guns.init.ModEntities;
import com.imguns.guns.init.ModEvents;
import com.imguns.guns.init.ModItems;
import com.imguns.guns.init.ModParticles;
import com.imguns.guns.init.ModRecipe;
import com.imguns.guns.init.ModSounds;
import com.imguns.guns.resource.DedicatedServerReloadManager;
import com.imguns.guns.util.EnvironmentUtil;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import net.fabricmc.api.ModInitializer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GunMod
implements ModInitializer {
    public static final String ORIGINAL_MOD_ID = "imguns";
    public static final String MOD_ID = "immersive_guns";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"immersive_guns");
    public static final String DEFAULT_GUN_PACK_NAME = "default_guns";

    public void onInitialize() {
        ForgeConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.init());
        ForgeConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.init());
        ForgeConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.init());
        ModEvents.init();
        ModBlocks.init();
        ModCreativeTabs.init();
        ModItems.init();
        ModEntities.init();
        ModRecipe.init();
        ModContainer.init();
        ModSounds.init();
        ModParticles.init();
        ModDamageTypes.init();
        CommonRegistry.init();
        CommandRegistry.init();
        CompatRegistry.init();
        GunModComponents.init();
        GunMod.registerDefaultExtraGunPack();
        if (EnvironmentUtil.isServer()) {
            DedicatedServerReloadManager.loadGunPack();
        }
    }

    private static void registerDefaultExtraGunPack() {
        String jarDefaultPackPath = String.format("/assets/%s/custom/%s", MOD_ID, DEFAULT_GUN_PACK_NAME);
        ResourceManager.registerExtraGunPack(GunMod.class, jarDefaultPackPath);
    }
}

