/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.api.client.animation.interpolator;

import com.imguns.guns.api.client.animation.AnimationChannelContent;
import com.imguns.guns.api.client.animation.interpolator.Interpolator;
import java.util.Arrays;

public class Step
implements Interpolator {
    private AnimationChannelContent content;

    @Override
    public void compile(AnimationChannelContent content) {
        this.content = content;
    }

    @Override
    public float[] interpolate(int indexFrom, int indexTo, float alpha) {
        float[] result;
        int offset;
        switch (this.content.values[indexFrom].length) {
            case 8: {
                int n = 4;
                break;
            }
            case 6: {
                int n = 3;
                break;
            }
            default: {
                int n = offset = 0;
            }
        }
        if (alpha < 1.0f || indexFrom == indexTo) {
            result = Arrays.copyOfRange(this.content.values[indexFrom], offset, this.content.values[indexFrom].length);
        } else {
            int length = this.content.values[indexTo].length;
            length = switch (length) {
                case 8 -> 4;
                case 6 -> 3;
                default -> length;
            };
            result = Arrays.copyOfRange(this.content.values[indexTo], 0, length);
        }
        return result;
    }

    @Override
    public Step clone() {
        try {
            Step step = (Step)super.clone();
            step.content = this.content;
            return step;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

