/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.api.client.animation.statemachine;

import com.imguns.guns.api.client.animation.AnimationController;
import com.imguns.guns.api.client.animation.statemachine.AnimationState;
import com.imguns.guns.api.client.animation.statemachine.AnimationStateContext;
import com.imguns.guns.api.client.animation.statemachine.LuaAnimationState;
import com.imguns.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.imguns.guns.api.client.animation.statemachine.LuaContextWrapper;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class LuaStateMachineFactory<T extends AnimationStateContext> {
    private AnimationController controller;
    private LuaFunction initializeFunc;
    private LuaFunction exitFunc;
    private LuaFunction statesFunc;

    public LuaAnimationStateMachine<T> build() {
        this.checkNullPointer();
        LuaAnimationStateMachine stateMachine = new LuaAnimationStateMachine(this.controller);
        stateMachine.initializeFunc = context -> {
            if (this.initializeFunc != null) {
                this.initializeFunc.call(context.getLuaContext());
            }
        };
        stateMachine.exitFunc = context -> {
            if (this.exitFunc != null) {
                this.exitFunc.call(context.getLuaContext());
            }
        };
        stateMachine.setStatesSupplier(this.getStatesSupplier());
        return stateMachine;
    }

    public LuaStateMachineFactory<T> setController(AnimationController controller) {
        this.controller = controller;
        return this;
    }

    public LuaStateMachineFactory<T> setLuaScripts(LuaTable table) {
        this.initializeFunc = this.checkFunction("initialize", table);
        this.exitFunc = this.checkFunction("exit", table);
        this.statesFunc = this.checkFunction("states", table);
        return this;
    }

    private LuaFunction checkFunction(String funcName, LuaTable table) {
        LuaValue value = table.get(funcName);
        if (value.isnil()) {
            return null;
        }
        return value.checkfunction();
    }

    private void checkNullPointer() {
        if (this.controller == null) {
            throw new IllegalStateException("controller must not be null before build");
        }
    }

    private Supplier<Iterable<? extends AnimationState<LuaContextWrapper<T>>>> getStatesSupplier() {
        if (this.statesFunc == null) {
            return null;
        }
        return () -> {
            LuaTable statesTable = this.statesFunc.call().checktable();
            LinkedList states = new LinkedList();
            for (int f = 1; f <= statesTable.length(); ++f) {
                LuaTable stateTable = statesTable.get(f).checktable();
                states.add(new LuaAnimationState(stateTable));
            }
            return states;
        };
    }
}

