/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.api.client.event;

import com.imguns.guns.api.event.GunBaseEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1268;
import net.minecraft.class_304;
import org.jetbrains.annotations.ApiStatus;

public abstract class InputEvent
extends GunBaseEvent {
    public void sendEvent() {
    }

    public static interface MousePreCallback {
        public void onMousePre(MouseButton.Pre var1);
    }

    public static interface MousePostCallback {
        public void onMousePost(MouseButton.Post var1);
    }

    public static interface MouseCallback {
        public void onMouse(MouseButton var1);
    }

    public static interface KeyCallback {
        public void onKey(Key var1);
    }

    public static interface IKMTCallback {
        public void onInteractionKeyMappingTriggered(InteractionKeyMappingTriggered var1);
    }

    public static class MouseButton
    extends InputEvent {
        public static final Event<MouseCallback> EVENT = EventFactory.createArrayBacked(MouseCallback.class, callbacks -> event -> {
            for (MouseCallback e : callbacks) {
                e.onMouse(event);
            }
        });
        private final int button;
        private final int action;
        private final int modifiers;

        @ApiStatus.Internal
        protected MouseButton(int button, int action, int modifiers) {
            this.button = button;
            this.action = action;
            this.modifiers = modifiers;
        }

        public int getButton() {
            return this.button;
        }

        public int getAction() {
            return this.action;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public void sendEvent() {
            super.sendEvent();
            ((MouseCallback)EVENT.invoker()).onMouse(this);
        }

        public static class Pre
        extends MouseButton {
            public static final Event<MousePreCallback> EVENT = EventFactory.createArrayBacked(MousePreCallback.class, callbacks -> event -> {
                for (MousePreCallback e : callbacks) {
                    e.onMousePre(event);
                }
            });

            @ApiStatus.Internal
            public Pre(int button, int action, int modifiers) {
                super(button, action, modifiers);
            }

            @Override
            public void sendEvent() {
                super.sendEvent();
                ((MousePreCallback)EVENT.invoker()).onMousePre(this);
            }
        }

        public static class Post
        extends MouseButton {
            public static final Event<MousePostCallback> EVENT = EventFactory.createArrayBacked(MousePostCallback.class, callbacks -> event -> {
                for (MousePostCallback e : callbacks) {
                    e.onMousePost(event);
                }
            });

            @ApiStatus.Internal
            public Post(int button, int action, int modifiers) {
                super(button, action, modifiers);
            }

            @Override
            public void sendEvent() {
                super.sendEvent();
                ((MousePostCallback)EVENT.invoker()).onMousePost(this);
            }
        }
    }

    public static class Key
    extends InputEvent {
        public static final Event<KeyCallback> EVENT = EventFactory.createArrayBacked(KeyCallback.class, callbacks -> event -> {
            for (KeyCallback e : callbacks) {
                e.onKey(event);
            }
        });
        private final int key;
        private final int scanCode;
        private final int action;
        private final int modifiers;

        @ApiStatus.Internal
        public Key(int key, int scanCode, int action, int modifiers) {
            this.key = key;
            this.scanCode = scanCode;
            this.action = action;
            this.modifiers = modifiers;
        }

        public int getKey() {
            return this.key;
        }

        public int getScanCode() {
            return this.scanCode;
        }

        public int getAction() {
            return this.action;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public void sendEvent() {
            super.sendEvent();
            ((KeyCallback)EVENT.invoker()).onKey(this);
        }
    }

    public static class InteractionKeyMappingTriggered
    extends InputEvent {
        public static final Event<IKMTCallback> EVENT = EventFactory.createArrayBacked(IKMTCallback.class, callbacks -> event -> {
            for (IKMTCallback e : callbacks) {
                e.onInteractionKeyMappingTriggered(event);
            }
        });
        private final int button;
        private final class_304 keyMapping;
        private final class_1268 hand;
        private boolean handSwing = true;

        public InteractionKeyMappingTriggered(int button, class_304 keyMapping, class_1268 hand) {
            this.button = button;
            this.keyMapping = keyMapping;
            this.hand = hand;
        }

        public void setSwingHand(boolean value) {
            this.handSwing = value;
        }

        public boolean shouldSwingHand() {
            return this.handSwing;
        }

        public class_1268 getHand() {
            return this.hand;
        }

        public boolean isAttack() {
            return this.button == 0;
        }

        public boolean isUseItem() {
            return this.button == 1;
        }

        public boolean isPickBlock() {
            return this.button == 2;
        }

        public class_304 getKeyMapping() {
            return this.keyMapping;
        }

        @Override
        public void sendEvent() {
            super.sendEvent();
            ((IKMTCallback)EVENT.invoker()).onInteractionKeyMappingTriggered(this);
        }
    }
}

