/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.api.item.gun;

import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.item.GunTabType;
import com.imguns.guns.api.item.IAttachment;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.attachment.AttachmentType;
import com.imguns.guns.api.item.builder.GunItemBuilder;
import com.imguns.guns.client.resource.index.ClientGunIndex;
import com.imguns.guns.inventory.tooltip.GunTooltip;
import com.imguns.guns.resource.index.CommonGunIndex;
import com.imguns.guns.resource.pojo.data.gun.GunData;
import com.imguns.guns.util.AllowAttachmentTagMatcher;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5632;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractGunItem
extends class_1792
implements IGun {
    protected AbstractGunItem(class_1792.class_1793 settings) {
        super(settings);
    }

    private static Comparator<Map.Entry<class_2960, CommonGunIndex>> idNameSort() {
        return Comparator.comparingInt(m -> ((CommonGunIndex)m.getValue()).getSort());
    }

    public abstract void bolt(class_1799 var1);

    public abstract void shoot(class_1799 var1, Supplier<Float> var2, Supplier<Float> var3, boolean var4, class_1309 var5);

    public abstract void fireSelect(class_1799 var1);

    public abstract void melee(class_1309 var1, class_1799 var2);

    public abstract void reloadAmmo(class_1799 var1, int var2, boolean var3);

    @Override
    public boolean allowAttachment(class_1799 gun, class_1799 attachmentItem) {
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentItem);
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun != null && iAttachment != null) {
            class_2960 gunId = iGun.getGunId(gun);
            class_2960 attachmentId = iAttachment.getAttachmentId(attachmentItem);
            return AllowAttachmentTagMatcher.match(gunId, attachmentId);
        }
        return false;
    }

    @Override
    public boolean allowAttachmentType(class_1799 gun, AttachmentType type) {
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun != null) {
            return TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).map(gunIndex -> {
                List<AttachmentType> allowAttachments = gunIndex.getGunData().getAllowAttachments();
                if (allowAttachments == null) {
                    return false;
                }
                return allowAttachments.contains((Object)type);
            }).orElse(false);
        }
        return false;
    }

    @NotNull
    @Environment(value=EnvType.CLIENT)
    public class_2561 method_7864(@NotNull class_1799 stack) {
        class_2960 gunId = this.getGunId(stack);
        Optional<ClientGunIndex> gunIndex = TimelessAPI.getClientGunIndex(gunId);
        if (gunIndex.isPresent()) {
            return class_2561.method_43471((String)gunIndex.get().getName());
        }
        return super.method_7864(stack);
    }

    public static class_2371<class_1799> fillItemCategory(GunTabType type) {
        class_2371 stacks = class_2371.method_10211();
        TimelessAPI.getAllCommonGunIndex().stream().sorted(AbstractGunItem.idNameSort()).forEach(entry -> {
            String indexType;
            CommonGunIndex index = (CommonGunIndex)entry.getValue();
            GunData gunData = index.getGunData();
            String key = type.name().toLowerCase(Locale.US);
            if (key.equals(indexType = index.getType())) {
                class_1799 itemStack = GunItemBuilder.create().setId((class_2960)entry.getKey()).setFireMode(gunData.getFireModeSet().get(0)).setAmmoCount(gunData.getAmmoAmount()).setAmmoInBarrel(true).build();
                stacks.add((Object)itemStack);
            }
        });
        return stacks;
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        return class_1269.field_5812;
    }

    @NotNull
    public Optional<class_5632> method_32346(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IGun) {
            IGun iGun = (IGun)class_17922;
            Optional<CommonGunIndex> optional = TimelessAPI.getCommonGunIndex(this.getGunId(stack));
            if (optional.isPresent()) {
                CommonGunIndex gunIndex = optional.get();
                class_2960 ammoId = gunIndex.getGunData().getAmmoId();
                return Optional.of(new GunTooltip(stack, iGun, ammoId, gunIndex));
            }
        }
        return Optional.empty();
    }
}

