/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.api.item.nbt;

import com.imguns.guns.api.DefaultAssets;
import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.item.IAttachment;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.attachment.AttachmentType;
import com.imguns.guns.api.item.gun.FireMode;
import com.imguns.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.imguns.guns.client.resource.index.ClientAttachmentIndex;
import com.imguns.guns.client.resource.index.ClientGunIndex;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GunItemDataAccessor
extends IGun {
    public static final String GUN_ID_TAG = "GunId";
    public static final String GUN_FIRE_MODE_TAG = "GunFireMode";
    public static final String GUN_HAS_BULLET_IN_BARREL = "HasBulletInBarrel";
    public static final String GUN_CURRENT_AMMO_COUNT_TAG = "GunCurrentAmmoCount";
    public static final String GUN_ATTACHMENT_BASE = "Attachment";
    public static final String GUN_EXP_TAG = "GunLevelExp";
    public static final String GUN_DUMMY_AMMO = "DummyAmmo";
    public static final String GUN_MAX_DUMMY_AMMO = "MaxDummyAmmo";
    public static final String GUN_ATTACHMENT_LOCK = "AttachmentLock";

    @Override
    default public boolean useDummyAmmo(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        return nbt.method_10573(GUN_DUMMY_AMMO, 3);
    }

    @Override
    default public int getDummyAmmoAmount(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        return Math.max(0, nbt.method_10550(GUN_DUMMY_AMMO));
    }

    @Override
    default public void setDummyAmmoAmount(class_1799 gun, int amount) {
        class_2487 nbt = gun.method_7948();
        nbt.method_10569(GUN_DUMMY_AMMO, Math.max(amount, 0));
    }

    @Override
    default public void addDummyAmmoAmount(class_1799 gun, int amount) {
        if (!this.useDummyAmmo(gun)) {
            return;
        }
        if (!this.hasMaxDummyAmmo(gun)) {
            return;
        }
        class_2487 nbt = gun.method_7948();
        amount = Math.min(this.getDummyAmmoAmount(gun) + amount, this.getMaxDummyAmmoAmount(gun));
        nbt.method_10569(GUN_DUMMY_AMMO, Math.max(amount, 0));
    }

    @Override
    default public boolean hasMaxDummyAmmo(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        return nbt.method_10573(GUN_MAX_DUMMY_AMMO, 3);
    }

    @Override
    default public int getMaxDummyAmmoAmount(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        return Math.max(0, nbt.method_10550(GUN_MAX_DUMMY_AMMO));
    }

    @Override
    default public void setMaxDummyAmmoAmount(class_1799 gun, int amount) {
        class_2487 nbt = gun.method_7948();
        nbt.method_10569(GUN_MAX_DUMMY_AMMO, Math.max(amount, 0));
    }

    @Override
    default public boolean hasAttachmentLock(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        if (nbt.method_10573(GUN_ATTACHMENT_LOCK, 1)) {
            return nbt.method_10577(GUN_ATTACHMENT_LOCK);
        }
        return false;
    }

    @Override
    default public void setAttachmentLock(class_1799 gun, boolean lock) {
        class_2487 nbt = gun.method_7948();
        nbt.method_10556(GUN_ATTACHMENT_LOCK, lock);
    }

    @Override
    @NotNull
    default public class_2960 getGunId(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        if (nbt.method_10573(GUN_ID_TAG, 8)) {
            class_2960 gunId = class_2960.method_12829((String)nbt.method_10558(GUN_ID_TAG));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_GUN_ID);
        }
        return DefaultAssets.EMPTY_GUN_ID;
    }

    @Override
    default public void setGunId(class_1799 gun, @Nullable class_2960 gunId) {
        class_2487 nbt = gun.method_7948();
        if (gunId != null) {
            nbt.method_10582(GUN_ID_TAG, gunId.toString());
        }
    }

    @Override
    default public int getLevel(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        if (nbt.method_10573(GUN_EXP_TAG, 3)) {
            return this.getLevel(nbt.method_10550(GUN_EXP_TAG));
        }
        return 0;
    }

    @Override
    default public int getExp(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        if (nbt.method_10573(GUN_EXP_TAG, 3)) {
            return nbt.method_10550(GUN_EXP_TAG);
        }
        return 0;
    }

    @Override
    default public int getExpToNextLevel(class_1799 gun) {
        int exp = this.getExp(gun);
        int level = this.getLevel(exp);
        if (level >= this.getMaxLevel()) {
            return 0;
        }
        int nextLevelExp = this.getExp(level + 1);
        return nextLevelExp - exp;
    }

    @Override
    default public int getExpCurrentLevel(class_1799 gun) {
        int exp = this.getExp(gun);
        int level = this.getLevel(exp);
        if (level <= 0) {
            return exp;
        }
        return exp - this.getExp(level - 1);
    }

    @Override
    default public FireMode getFireMode(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        if (nbt.method_10573(GUN_FIRE_MODE_TAG, 8)) {
            return FireMode.valueOf(nbt.method_10558(GUN_FIRE_MODE_TAG));
        }
        return FireMode.UNKNOWN;
    }

    @Override
    default public void setFireMode(class_1799 gun, @Nullable FireMode fireMode) {
        class_2487 nbt = gun.method_7948();
        if (fireMode != null) {
            nbt.method_10582(GUN_FIRE_MODE_TAG, fireMode.name());
            return;
        }
        nbt.method_10582(GUN_FIRE_MODE_TAG, FireMode.UNKNOWN.name());
    }

    @Override
    default public int getCurrentAmmoCount(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        if (nbt.method_10573(GUN_CURRENT_AMMO_COUNT_TAG, 3)) {
            return nbt.method_10550(GUN_CURRENT_AMMO_COUNT_TAG);
        }
        return 0;
    }

    @Override
    default public void setCurrentAmmoCount(class_1799 gun, int ammoCount) {
        class_2487 nbt = gun.method_7948();
        nbt.method_10569(GUN_CURRENT_AMMO_COUNT_TAG, Math.max(ammoCount, 0));
    }

    @Override
    default public void reduceCurrentAmmoCount(class_1799 gun) {
        this.setCurrentAmmoCount(gun, this.getCurrentAmmoCount(gun) - 1);
    }

    @Override
    @Nullable
    default public class_2487 getAttachmentTag(class_1799 gun, AttachmentType type) {
        class_2487 allItemStackTag;
        String key;
        if (!this.allowAttachmentType(gun, type)) {
            return null;
        }
        class_2487 nbt = gun.method_7948();
        if (nbt.method_10573(key = GUN_ATTACHMENT_BASE + type.name(), 10) && (allItemStackTag = nbt.method_10562(key)).method_10573("tag", 10)) {
            return allItemStackTag.method_10562("tag");
        }
        return null;
    }

    @Override
    @NotNull
    default public class_1799 getAttachment(class_1799 gun, AttachmentType type) {
        String key;
        if (!this.allowAttachmentType(gun, type)) {
            return class_1799.field_8037;
        }
        class_2487 nbt = gun.method_7948();
        if (nbt.method_10573(key = GUN_ATTACHMENT_BASE + type.name(), 10)) {
            return class_1799.method_7915((class_2487)nbt.method_10562(key));
        }
        return class_1799.field_8037;
    }

    @Override
    @NotNull
    default public class_2960 getAttachmentId(class_1799 gun, AttachmentType type) {
        class_2487 attachmentTag = this.getAttachmentTag(gun, type);
        if (attachmentTag != null) {
            return AttachmentItemDataAccessor.getAttachmentIdFromTag(attachmentTag);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    @Override
    default public void installAttachment(@NotNull class_1799 gun, @NotNull class_1799 attachment) {
        if (!this.allowAttachment(gun, attachment)) {
            return;
        }
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachment);
        if (iAttachment == null) {
            return;
        }
        class_2487 nbt = gun.method_7948();
        String key = GUN_ATTACHMENT_BASE + iAttachment.getType(attachment).name();
        class_2487 attachmentTag = new class_2487();
        attachment.method_7953(attachmentTag);
        nbt.method_10566(key, (class_2520)attachmentTag);
    }

    @Override
    default public void unloadAttachment(@NotNull class_1799 gun, AttachmentType type) {
        if (!this.allowAttachmentType(gun, type)) {
            return;
        }
        class_2487 nbt = gun.method_7948();
        String key = GUN_ATTACHMENT_BASE + type.name();
        class_2487 attachmentTag = new class_2487();
        class_1799.field_8037.method_7953(attachmentTag);
        nbt.method_10566(key, (class_2520)attachmentTag);
    }

    @Override
    default public float getAimingZoom(class_1799 gunItem) {
        float zoom = 1.0f;
        class_2960 scopeId = this.getAttachmentId(gunItem, AttachmentType.SCOPE);
        if (!DefaultAssets.isEmptyAttachmentId(scopeId)) {
            class_2487 attachmentTag = this.getAttachmentTag(gunItem, AttachmentType.SCOPE);
            int zoomNumber = AttachmentItemDataAccessor.getZoomNumberFromTag(attachmentTag);
            float[] zooms = TimelessAPI.getClientAttachmentIndex(scopeId).map(ClientAttachmentIndex::getZoom).orElse(null);
            if (zooms != null) {
                zoom = zooms[zoomNumber % zooms.length];
            }
        } else {
            class_2960 gunId = this.getGunId(gunItem);
            zoom = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getIronZoom).orElse(Float.valueOf(1.0f)).floatValue();
        }
        return zoom;
    }

    @Override
    default public boolean hasBulletInBarrel(class_1799 gun) {
        class_2487 nbt = gun.method_7948();
        if (nbt.method_10573(GUN_HAS_BULLET_IN_BARREL, 1)) {
            return nbt.method_10577(GUN_HAS_BULLET_IN_BARREL);
        }
        return false;
    }

    @Override
    default public void setBulletInBarrel(class_1799 gun, boolean bulletInBarrel) {
        class_2487 nbt = gun.method_7948();
        nbt.method_10556(GUN_HAS_BULLET_IN_BARREL, bulletInBarrel);
    }
}

