/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.animation.screen;

import com.imguns.guns.api.client.event.RenderTickEvent;
import com.imguns.guns.api.item.attachment.AttachmentType;
import com.imguns.guns.client.gui.GunRefitScreen;
import java.util.Objects;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class RefitTransform {
    private static final float REFIT_SCREEN_TRANSFORM_TIMES = 0.25f;
    private static float refitScreenTransformProgress = 1.0f;
    private static long refitScreenTransformTimestamp = -1L;
    private static AttachmentType oldTransformType = AttachmentType.NONE;
    private static AttachmentType currentTransformType = AttachmentType.NONE;
    private static float refitScreenOpeningProgress = 0.0f;
    private static long refitScreenOpeningTimestamp = -1L;

    public static void init() {
        refitScreenTransformProgress = 1.0f;
        refitScreenTransformTimestamp = System.currentTimeMillis();
        oldTransformType = AttachmentType.NONE;
        currentTransformType = AttachmentType.NONE;
    }

    public static float getOpeningProgress() {
        return refitScreenOpeningProgress;
    }

    @NotNull
    public static AttachmentType getOldTransformType() {
        return Objects.requireNonNullElse(oldTransformType, AttachmentType.NONE);
    }

    @NotNull
    public static AttachmentType getCurrentTransformType() {
        return Objects.requireNonNullElse(currentTransformType, AttachmentType.NONE);
    }

    public static float getTransformProgress() {
        return refitScreenTransformProgress;
    }

    public static boolean changeRefitScreenView(AttachmentType attachmentType) {
        if (refitScreenTransformProgress != 1.0f || refitScreenOpeningProgress != 1.0f) {
            return false;
        }
        oldTransformType = currentTransformType;
        currentTransformType = attachmentType;
        refitScreenTransformProgress = 0.0f;
        refitScreenTransformTimestamp = System.currentTimeMillis();
        return true;
    }

    public static void tickInterpolation(RenderTickEvent ignoredEvent) {
        if (refitScreenOpeningTimestamp == -1L) {
            refitScreenOpeningTimestamp = System.currentTimeMillis();
        }
        if (class_310.method_1551().field_1755 instanceof GunRefitScreen) {
            if ((refitScreenOpeningProgress += (float)(System.currentTimeMillis() - refitScreenOpeningTimestamp) / 250.0f) > 1.0f) {
                refitScreenOpeningProgress = 1.0f;
            }
        } else if ((refitScreenOpeningProgress -= (float)(System.currentTimeMillis() - refitScreenOpeningTimestamp) / 250.0f) < 0.0f) {
            refitScreenOpeningProgress = 0.0f;
        }
        refitScreenOpeningTimestamp = System.currentTimeMillis();
        if (refitScreenTransformTimestamp == -1L) {
            refitScreenTransformTimestamp = System.currentTimeMillis();
        }
        if ((refitScreenTransformProgress += (float)(System.currentTimeMillis() - refitScreenTransformTimestamp) / 250.0f) > 1.0f) {
            refitScreenTransformProgress = 1.0f;
        }
        refitScreenTransformTimestamp = System.currentTimeMillis();
    }
}

