/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.download;

import com.google.common.collect.Maps;
import com.imguns.guns.GunMod;
import com.imguns.guns.client.gui.GunPackProgressScreen;
import com.imguns.guns.client.resource.ClientReloadManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_3521;
import net.minecraft.class_3536;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_6489;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class ClientGunPackDownloader {
    private static final int MAX_FILE_SIZE = 0xFA00000;
    private final ReentrantLock downloadLock = new ReentrantLock();
    private final Path serverGunPackPath;
    @Nullable
    private CompletableFuture<?> currentDownload;

    public ClientGunPackDownloader(Path serverGunPackPath) {
        this.serverGunPackPath = serverGunPackPath;
    }

    private static Map<String, String> getDownloadHeaders() {
        HashMap map = Maps.newHashMap();
        class_320 user = class_310.method_1551().method_1548();
        class_6489 currentVersion = class_155.method_16673();
        map.put("X-Minecraft-Username", user.method_1676());
        map.put("X-Minecraft-UUID", user.method_1673());
        map.put("X-Minecraft-Version", currentVersion.method_48019());
        map.put("X-Minecraft-Version-ID", currentVersion.method_48018());
        map.put("X-IMGUNS-Version", ((ModContainer)FabricLoader.getInstance().getModContainer("immersive_guns").orElseThrow()).getMetadata().getVersion().getFriendlyString());
        map.put("User-Agent", "Minecraft Java/" + currentVersion.method_48019());
        return map;
    }

    public CompletableFuture<?> downloadAndLoadGunPack(String plainUrl, String hash) {
        CompletableFuture<?> resultFuture;
        this.downloadLock.lock();
        try {
            CompletableFuture downloadFuture;
            this.clearDownloadingGunPack();
            File gunPack = this.serverGunPackPath.resolve(hash).toFile();
            this.removeMismatchFile(hash, gunPack);
            if (gunPack.exists()) {
                downloadFuture = CompletableFuture.completedFuture("");
            } else {
                GunPackProgressScreen progressScreen = new GunPackProgressScreen();
                class_310 minecraft = class_310.method_1551();
                minecraft.method_19537(() -> minecraft.method_1507((class_437)progressScreen));
                URL url = new URL(plainUrl);
                downloadFuture = class_3521.method_15301((File)gunPack, (URL)url, ClientGunPackDownloader.getDownloadHeaders(), (int)0xFA00000, (class_3536)progressScreen, (Proxy)minecraft.method_1487());
            }
            resultFuture = this.currentDownload = ((CompletableFuture)downloadFuture.thenCompose(target -> {
                if (this.notMatchHash(hash, gunPack)) {
                    return ClientGunPackDownloader.failedFuture(new RuntimeException("Hash check failure for file " + String.valueOf(gunPack) + ", see log"));
                }
                return this.loadClientGunPack(gunPack);
            })).whenComplete((target, throwable) -> this.afterFail((Throwable)throwable, gunPack));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.downloadLock.unlock();
        }
        return resultFuture;
    }

    public static <T> CompletableFuture<T> failedFuture(Throwable pTerminationException) {
        CompletableFuture completablefuture = new CompletableFuture();
        completablefuture.completeExceptionally(pTerminationException);
        return completablefuture;
    }

    private void afterFail(Throwable throwable, File gunPack) {
        if (throwable == null) {
            return;
        }
        GunMod.LOGGER.warn("Pack application failed: {}, deleting file {}", (Object)throwable.getMessage(), (Object)gunPack);
        try {
            Files.delete(gunPack.toPath());
        }
        catch (IOException exception) {
            GunMod.LOGGER.warn("Failed to delete file {}: {}", (Object)gunPack, (Object)exception.getMessage());
        }
        class_310.method_1551().execute(() -> this.displayFailScreen(class_310.method_1551()));
    }

    private void displayFailScreen(class_310 mc) {
        class_5250 title = class_2561.method_43471((String)"gui.immersive_guns.client_gun_pack_downloader.fail.title");
        class_5250 subTitle = class_2561.method_43471((String)"gui.immersive_guns.client_gun_pack_downloader.fail.subtitle");
        class_2561 yesButton = class_5244.field_24338;
        class_5250 noButton = class_2561.method_43471((String)"menu.disconnect");
        mc.method_1507((class_437)new class_410(button -> {
            if (button) {
                mc.method_1507(null);
            } else {
                class_634 clientpacketlistener = mc.method_1562();
                if (clientpacketlistener != null) {
                    clientpacketlistener.method_48296().method_10747((class_2561)class_2561.method_43471((String)"connect.aborted"));
                }
            }
        }, (class_2561)title, (class_2561)subTitle, yesButton, (class_2561)noButton));
    }

    public void clearDownloadingGunPack() {
        this.downloadLock.lock();
        try {
            if (this.currentDownload != null) {
                this.currentDownload.cancel(true);
            }
            this.currentDownload = null;
        }
        finally {
            this.downloadLock.unlock();
        }
    }

    public void removeMismatchFile(String expectedHash, File file) {
        if (file.exists() && this.notMatchHash(expectedHash, file)) {
            try {
                FileUtils.delete((File)file);
            }
            catch (IOException exception) {
                GunMod.LOGGER.warn("Failed to delete file {}: {}", (Object)file, (Object)exception.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean notMatchHash(String expectedHash, File file) {
        try (FileInputStream stream = new FileInputStream(file);){
            String fileHash = DigestUtils.sha1Hex((InputStream)stream);
            if (fileHash.toLowerCase(Locale.US).equals(expectedHash.toLowerCase(Locale.US))) {
                GunMod.LOGGER.info("Found file {} matching requested fileHash {}", (Object)file, (Object)expectedHash);
                boolean bl = false;
                return bl;
            }
            GunMod.LOGGER.warn("File {} had wrong fileHash (expected {}, found {}).", new Object[]{file, expectedHash, fileHash});
            return true;
        }
        catch (IOException ioexception) {
            GunMod.LOGGER.warn("File {} couldn't be hashed.", (Object)file, (Object)ioexception);
        }
        return true;
    }

    public CompletableFuture<?> loadClientGunPack(File file) {
        ClientReloadManager.loadClientDownloadGunPack(file);
        return CompletableFuture.completedFuture("");
    }
}

