/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.event;

import com.imguns.guns.api.DefaultAssets;
import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.client.event.BeforeRenderHandEvent;
import com.imguns.guns.api.client.event.ViewportEvent;
import com.imguns.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.imguns.guns.api.client.other.KeepingItemRenderer;
import com.imguns.guns.api.entity.IGunOperator;
import com.imguns.guns.api.event.common.GunFireEvent;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.attachment.AttachmentType;
import com.imguns.guns.client.model.BedrockGunModel;
import com.imguns.guns.client.resource.index.ClientAttachmentIndex;
import com.imguns.guns.client.resource.index.ClientGunIndex;
import com.imguns.guns.resource.pojo.data.attachment.RecoilModifier;
import com.imguns.guns.resource.pojo.data.gun.GunData;
import com.imguns.guns.util.AttachmentDataUtils;
import com.imguns.guns.util.math.MathUtil;
import com.imguns.guns.util.math.SecondOrderDynamics;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.joml.Quaternionf;

public class CameraSetupEvent {
    private static final SecondOrderDynamics WORLD_FOV_DYNAMICS = new SecondOrderDynamics(0.5f, 1.2f, 0.5f, 0.0f);
    private static final SecondOrderDynamics ITEM_MODEL_FOV_DYNAMICS = new SecondOrderDynamics(0.5f, 1.2f, 0.5f, 0.0f);
    private static PolynomialSplineFunction pitchSplineFunction;
    private static PolynomialSplineFunction yawSplineFunction;
    private static long shootTimeStamp;
    private static double xRotO;
    private static double yRot0;
    private static BedrockGunModel lastModel;

    public static void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event) {
        if (!((Boolean)class_310.method_1551().field_1690.method_42448().method_41753()).booleanValue()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1799 stack = KeepingItemRenderer.getRenderer().getCurrentItem();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        TimelessAPI.getClientGunIndex(iGun.getGunId(stack)).ifPresent(gunIndex -> {
            BedrockGunModel gunModel = gunIndex.getGunModel();
            if (lastModel != gunModel) {
                gunModel.cleanCameraAnimationTransform();
                lastModel = gunModel;
            }
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = class_310.method_1551().method_1488();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(stack);
            float multiplier = 1.0f - aimingProgress + aimingProgress / (float)Math.sqrt(zoom);
            Quaternionf q = MathUtil.multiplyQuaternion(gunModel.getCameraAnimationObject().rotationQuaternion, multiplier);
            double yaw = Math.asin(2.0f * (q.w() * q.y() - q.x() * q.z()));
            double pitch = Math.atan2(2.0f * (q.w() * q.x() + q.y() * q.z()), 1.0f - 2.0f * (q.x() * q.x() + q.y() * q.y()));
            double roll = Math.atan2(2.0f * (q.w() * q.z() + q.x() * q.y()), 1.0f - 2.0f * (q.y() * q.y() + q.z() * q.z()));
            yaw = Math.toDegrees(yaw);
            pitch = Math.toDegrees(pitch);
            roll = Math.toDegrees(roll);
            event.setYaw((float)yaw + event.getYaw());
            event.setPitch((float)pitch + event.getPitch());
            event.setRoll((float)roll + event.getRoll());
        });
    }

    public static void onBeforeRenderHand(BeforeRenderHandEvent event) {
        if (!((Boolean)class_310.method_1551().field_1690.method_42448().method_41753()).booleanValue()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1799 stack = KeepingItemRenderer.getRenderer().getCurrentItem();
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        TimelessAPI.getClientGunIndex(iGun.getGunId(stack)).ifPresent(gunIndex -> {
            BedrockGunModel gunModel = gunIndex.getGunModel();
            class_4587 poseStack = event.getPoseStack();
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = class_310.method_1551().method_1488();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(stack);
            float multiplier = 1.0f - aimingProgress + aimingProgress / (float)Math.sqrt(zoom);
            Quaternionf quaternion = MathUtil.multiplyQuaternion(gunModel.getCameraAnimationObject().rotationQuaternion, multiplier);
            poseStack.method_22907(quaternion);
            gunModel.cleanCameraAnimationTransform();
        });
    }

    public static void applyScopeMagnification(ViewportEvent.ComputeFov event) {
        if (!event.usedConfiguredFov()) {
            return;
        }
        class_1297 entity = event.getCamera().method_19331();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            class_1799 stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof IGun)) {
                float fov = WORLD_FOV_DYNAMICS.update((float)event.getFOV());
                event.setFOV(fov);
                return;
            }
            IGun iGun = (IGun)class_17922;
            float zoom = iGun.getAimingZoom(stack);
            if (livingEntity instanceof class_746) {
                class_746 localPlayer = (class_746)livingEntity;
                IClientPlayerGunOperator gunOperator = IClientPlayerGunOperator.fromLocalPlayer(localPlayer);
                float aimingProgress = gunOperator.getClientAimingProgress((float)event.getPartialTick());
                float fov = WORLD_FOV_DYNAMICS.update((float)MathUtil.magnificationToFov(1.0f + (zoom - 1.0f) * aimingProgress, event.getFOV()));
                event.setFOV(fov);
            } else {
                IGunOperator gunOperator = IGunOperator.fromLivingEntity(livingEntity);
                float aimingProgress = gunOperator.getSynAimingProgress();
                float fov = WORLD_FOV_DYNAMICS.update((float)MathUtil.magnificationToFov(1.0f + (zoom - 1.0f) * aimingProgress, event.getFOV()));
                event.setFOV(fov);
            }
        }
    }

    public static void applyGunModelFovModifying(ViewportEvent.ComputeFov event) {
        if (event.usedConfiguredFov()) {
            return;
        }
        class_1297 entity = event.getCamera().method_19331();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            class_1799 stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof IGun)) {
                float fov = ITEM_MODEL_FOV_DYNAMICS.update((float)event.getFOV());
                event.setFOV(fov);
                return;
            }
            IGun iGun = (IGun)class_17922;
            class_2960 scopeItemId = iGun.getAttachmentId(stack, AttachmentType.SCOPE);
            if (DefaultAssets.isEmptyAttachmentId(scopeItemId)) {
                float fov = ITEM_MODEL_FOV_DYNAMICS.update((float)event.getFOV());
                event.setFOV(fov);
                return;
            }
            float modifiedFov = TimelessAPI.getClientAttachmentIndex(scopeItemId).map(ClientAttachmentIndex::getFov).orElse(Float.valueOf((float)event.getFOV())).floatValue();
            if (livingEntity instanceof class_746) {
                class_746 localPlayer = (class_746)livingEntity;
                IClientPlayerGunOperator gunOperator = IClientPlayerGunOperator.fromLocalPlayer(localPlayer);
                float aimingProgress = gunOperator.getClientAimingProgress((float)event.getPartialTick());
                float fov = ITEM_MODEL_FOV_DYNAMICS.update(class_3532.method_16439((float)aimingProgress, (float)((float)event.getFOV()), (float)modifiedFov));
                event.setFOV(fov);
            } else {
                IGunOperator gunOperator = IGunOperator.fromLivingEntity(livingEntity);
                float aimingProgress = gunOperator.getSynAimingProgress();
                float fov = ITEM_MODEL_FOV_DYNAMICS.update(class_3532.method_16439((float)aimingProgress, (float)((float)event.getFOV()), (float)modifiedFov));
                event.setFOV(fov);
            }
        }
    }

    public static void initialCameraRecoil(GunFireEvent event) {
        if (event.getLogicalSide().isClient()) {
            class_746 player;
            class_1309 shooter = event.getShooter();
            if (!shooter.equals((Object)(player = class_310.method_1551().field_1724))) {
                return;
            }
            class_1799 mainhandItem = player.method_6047();
            class_1792 class_17922 = mainhandItem.method_7909();
            if (!(class_17922 instanceof IGun)) {
                return;
            }
            IGun iGun = (IGun)class_17922;
            class_2960 gunId = iGun.getGunId(mainhandItem);
            Optional<ClientGunIndex> gunIndexOptional = TimelessAPI.getClientGunIndex(gunId);
            if (gunIndexOptional.isEmpty()) {
                return;
            }
            ClientGunIndex gunIndex = gunIndexOptional.get();
            GunData gunData = gunIndex.getGunData();
            float[] attachmentRecoilModifier = new float[]{0.0f, 0.0f};
            AttachmentDataUtils.getAllAttachmentData(mainhandItem, gunData, attachmentData -> {
                RecoilModifier recoilModifier = attachmentData.getRecoilModifier();
                if (recoilModifier == null) {
                    return;
                }
                attachmentRecoilModifier[0] = attachmentRecoilModifier[0] + recoilModifier.getPitch();
                attachmentRecoilModifier[1] = attachmentRecoilModifier[1] + recoilModifier.getYaw();
            });
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = class_310.method_1551().method_1488();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(mainhandItem);
            float aimingRecoilModifier = 1.0f - aimingProgress + aimingProgress / (float)Math.sqrt(zoom);
            pitchSplineFunction = gunData.getRecoil().genPitchSplineFunction(CameraSetupEvent.modifierNumber(attachmentRecoilModifier[0]) * aimingRecoilModifier);
            yawSplineFunction = gunData.getRecoil().genYawSplineFunction(CameraSetupEvent.modifierNumber(attachmentRecoilModifier[1]) * aimingRecoilModifier);
            shootTimeStamp = System.currentTimeMillis();
            xRotO = 0.0;
        }
    }

    public static void applyCameraRecoil(ViewportEvent.ComputeCameraAngles ignoredEvent) {
        double value;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        long timeTotal = System.currentTimeMillis() - shootTimeStamp;
        if (pitchSplineFunction != null && pitchSplineFunction.isValidPoint((double)timeTotal)) {
            value = pitchSplineFunction.value((double)timeTotal);
            player.method_36457(player.method_36455() - (float)(value - xRotO));
            xRotO = value;
        }
        if (yawSplineFunction != null && yawSplineFunction.isValidPoint((double)timeTotal)) {
            value = yawSplineFunction.value((double)timeTotal);
            player.method_36456(player.method_36454() - (float)(value - yRot0));
            yRot0 = value;
        }
    }

    private static float modifierNumber(float modifier) {
        return Math.max(0.0f, 1.0f + modifier);
    }

    static {
        shootTimeStamp = -1L;
        xRotO = 0.0;
        yRot0 = 0.0;
        lastModel = null;
    }
}

