/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.gameplay;

import com.imguns.guns.api.DefaultAssets;
import com.imguns.guns.api.LogicalSide;
import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.event.common.GunMeleeEvent;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.attachment.AttachmentType;
import com.imguns.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.imguns.guns.client.gameplay.LocalPlayerDataHolder;
import com.imguns.guns.client.sound.SoundPlayManager;
import com.imguns.guns.network.NetworkHandler;
import com.imguns.guns.network.message.ClientMessagePlayerMelee;
import com.imguns.guns.resource.pojo.data.attachment.MeleeData;
import com.imguns.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class LocalPlayerMelee {
    private final LocalPlayerDataHolder data;
    private final class_746 player;
    private int meleeCounter = 0;

    public LocalPlayerMelee(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public void melee() {
        if (this.data.clientStateLock) {
            return;
        }
        class_1799 mainhandItem = this.player.method_6047();
        class_1792 class_17922 = mainhandItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(mainhandItem);
        class_2960 muzzleId = iGun.getAttachmentId(mainhandItem, AttachmentType.MUZZLE);
        MeleeData muzzleMeleeData = this.getMeleeData(muzzleId);
        if (muzzleMeleeData != null) {
            this.doMuzzleMelee(gunId);
            return;
        }
        class_2960 stockId = iGun.getAttachmentId(mainhandItem, AttachmentType.STOCK);
        MeleeData stockMeleeData = this.getMeleeData(stockId);
        if (stockMeleeData != null) {
            this.doStockMelee(gunId);
            return;
        }
        TimelessAPI.getClientGunIndex(gunId).ifPresent(index -> {
            GunDefaultMeleeData defaultMeleeData = index.getGunData().getMeleeData().getDefaultMeleeData();
            if (defaultMeleeData == null) {
                return;
            }
            String animationType = defaultMeleeData.getAnimationType();
            if ("melee_stock".equals(animationType)) {
                this.doStockMelee(gunId);
                return;
            }
            this.doPushMelee(gunId);
        });
    }

    private boolean prepareMelee() {
        this.data.lockState(operator -> operator.getSynMeleeCoolDown() > 0L);
        GunMeleeEvent gunMeleeEvent = new GunMeleeEvent((class_1309)this.player, this.player.method_6047(), LogicalSide.CLIENT);
        return !gunMeleeEvent.post();
    }

    private void doMuzzleMelee(class_2960 gunId) {
        if (this.prepareMelee()) {
            TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
                SoundPlayManager.playMeleeBayonetSound((class_1309)this.player, gunIndex);
                NetworkHandler.sendToServer(new ClientMessagePlayerMelee());
                GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
                if (animationStateMachine != null) {
                    animationStateMachine.onBayonetAttack(this.meleeCounter);
                    this.meleeCounter = (this.meleeCounter + 1) % 3;
                }
            });
        }
    }

    private void doStockMelee(class_2960 gunId) {
        if (this.prepareMelee()) {
            TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
                SoundPlayManager.playMeleeStockSound((class_1309)this.player, gunIndex);
                NetworkHandler.sendToServer(new ClientMessagePlayerMelee());
                GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
                if (animationStateMachine != null) {
                    animationStateMachine.onStockAttack();
                }
            });
        }
    }

    private void doPushMelee(class_2960 gunId) {
        if (this.prepareMelee()) {
            TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
                SoundPlayManager.playMeleePushSound((class_1309)this.player, gunIndex);
                NetworkHandler.sendToServer(new ClientMessagePlayerMelee());
                GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
                if (animationStateMachine != null) {
                    animationStateMachine.onPushAttack();
                }
            });
        }
    }

    @Nullable
    private MeleeData getMeleeData(class_2960 attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getClientAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }
}

