/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.gameplay;

import com.imguns.guns.api.LogicalSide;
import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.imguns.guns.api.entity.IGunOperator;
import com.imguns.guns.api.entity.ShootResult;
import com.imguns.guns.api.event.common.GunFireEvent;
import com.imguns.guns.api.event.common.GunShootEvent;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.gun.FireMode;
import com.imguns.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.imguns.guns.client.gameplay.LocalPlayerDataHolder;
import com.imguns.guns.client.resource.index.ClientGunIndex;
import com.imguns.guns.client.sound.SoundPlayManager;
import com.imguns.guns.network.NetworkHandler;
import com.imguns.guns.network.message.ClientMessagePlayerShoot;
import com.imguns.guns.resource.index.CommonGunIndex;
import com.imguns.guns.resource.pojo.data.gun.Bolt;
import com.imguns.guns.resource.pojo.data.gun.GunData;
import com.imguns.guns.sound.SoundManager;
import com.imguns.guns.util.AttachmentDataUtils;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class LocalPlayerShoot {
    private static final Predicate<IGunOperator> SHOOT_LOCKED_CONDITION = operator -> operator.getSynShootCoolDown() > 0L;
    private final LocalPlayerDataHolder data;
    private final class_746 player;

    public LocalPlayerShoot(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public ShootResult shoot() {
        if (System.currentTimeMillis() - LocalPlayerDataHolder.clientClickButtonTimestamp < 50L) {
            return ShootResult.COOL_DOWN;
        }
        if (!this.data.isShootRecorded) {
            return ShootResult.COOL_DOWN;
        }
        if (this.data.clientStateLock && this.data.lockedCondition != SHOOT_LOCKED_CONDITION && this.data.lockedCondition != null) {
            this.data.isShootRecorded = true;
            return ShootResult.IS_DRAWING;
        }
        class_1799 mainhandItem = this.player.method_6047();
        class_1792 class_17922 = mainhandItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return ShootResult.NOT_GUN;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(mainhandItem);
        Optional<ClientGunIndex> gunIndexOptional = TimelessAPI.getClientGunIndex(gunId);
        if (gunIndexOptional.isEmpty()) {
            return ShootResult.ID_NOT_EXIST;
        }
        ClientGunIndex gunIndex = gunIndexOptional.get();
        GunData gunData = gunIndex.getGunData();
        long coolDown = this.getCoolDown(iGun, mainhandItem, gunData);
        if (coolDown >= 50L) {
            return ShootResult.COOL_DOWN;
        }
        IGunOperator gunOperator = IGunOperator.fromLivingEntity((class_1309)this.player);
        if (gunOperator.getSynReloadState().getStateType().isReloading()) {
            return ShootResult.IS_RELOADING;
        }
        if (gunOperator.getSynDrawCoolDown() != 0L) {
            return ShootResult.IS_DRAWING;
        }
        if (gunOperator.getSynMeleeCoolDown() != 0L) {
            return ShootResult.IS_MELEE;
        }
        Bolt boltType = gunIndex.getGunData().getBolt();
        boolean hasAmmoInBarrel = iGun.hasBulletInBarrel(mainhandItem) && boltType != Bolt.OPEN_BOLT;
        int ammoCount = iGun.getCurrentAmmoCount(mainhandItem) + (hasAmmoInBarrel ? 1 : 0);
        if (ammoCount < 1) {
            SoundPlayManager.playDryFireSound((class_1309)this.player, gunIndex);
            return ShootResult.NO_AMMO;
        }
        if (boltType == Bolt.MANUAL_ACTION && !hasAmmoInBarrel) {
            IClientPlayerGunOperator.fromLocalPlayer(this.player).bolt();
            return ShootResult.NEED_BOLT;
        }
        if (gunOperator.getSynSprintTime() > 0.0f) {
            return ShootResult.IS_SPRINTING;
        }
        if (new GunShootEvent((class_1309)this.player, mainhandItem, LogicalSide.CLIENT).post()) {
            return ShootResult.FORGE_EVENT_CANCEL;
        }
        this.data.lockState(SHOOT_LOCKED_CONDITION);
        this.data.isShootRecorded = false;
        this.doShoot(gunIndex, iGun, mainhandItem, gunData, coolDown);
        return ShootResult.SUCCESS;
    }

    private void doShoot(ClientGunIndex gunIndex, IGun iGun, class_1799 mainhandItem, GunData gunData, long delay) {
        boolean hasAmmoInBarrel;
        FireMode fireMode = iGun.getFireMode(mainhandItem);
        Bolt boltType = gunIndex.getGunData().getBolt();
        boolean consumeAmmo = IGunOperator.fromLivingEntity((class_1309)this.player).consumesAmmoOrNot();
        boolean bl = hasAmmoInBarrel = iGun.hasBulletInBarrel(mainhandItem) && boltType != Bolt.OPEN_BOLT;
        int ammoCount = consumeAmmo ? iGun.getCurrentAmmoCount(mainhandItem) + (hasAmmoInBarrel ? 1 : 0) : Integer.MAX_VALUE;
        long period = fireMode == FireMode.BURST ? gunData.getBurstShootInterval() : 1L;
        int maxCount = Math.min(ammoCount, fireMode == FireMode.BURST ? gunData.getBurstData().getCount() : 1);
        AtomicInteger count = new AtomicInteger(0);
        LocalPlayerDataHolder.SCHEDULED_EXECUTOR_SERVICE.scheduleAtFixedRate(() -> {
            boolean fire;
            if (count.get() == 0) {
                this.data.isShootRecorded = true;
            }
            if (count.get() >= maxCount || this.player.method_29504()) {
                ScheduledFuture future = (ScheduledFuture)((Object)Thread.currentThread());
                future.cancel(false);
                return;
            }
            if (count.get() == 0) {
                if (this.data.clientStateLock && this.data.lockedCondition != SHOOT_LOCKED_CONDITION && this.data.lockedCondition != null) {
                    return;
                }
                this.data.clientShootTimestamp = System.currentTimeMillis();
                NetworkHandler.sendToServer(new ClientMessagePlayerShoot());
            }
            boolean bl = fire = !new GunFireEvent((class_1309)this.player, mainhandItem, LogicalSide.CLIENT).post();
            if (fire) {
                GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
                if (animationStateMachine != null) {
                    animationStateMachine.onGunShoot();
                }
                boolean useSilenceSound = this.useSilenceSound(mainhandItem, gunData);
                class_310.method_1551().method_5382(() -> {
                    SoundPlayManager.stopPlayGunSound(gunIndex, SoundManager.INSPECT_SOUND);
                    if (useSilenceSound) {
                        SoundPlayManager.playSilenceSound((class_1309)this.player, gunIndex);
                    } else {
                        SoundPlayManager.playShootSound((class_1309)this.player, gunIndex);
                    }
                });
            }
            count.getAndIncrement();
        }, delay, period, TimeUnit.MILLISECONDS);
    }

    private boolean useSilenceSound(class_1799 mainhandItem, GunData gunData) {
        boolean[] useSilenceSound = new boolean[]{false};
        AttachmentDataUtils.getAllAttachmentData(mainhandItem, gunData, attachmentData -> {
            if (attachmentData.getSilence() != null && attachmentData.getSilence().isUseSilenceSound()) {
                useSilenceSound[0] = true;
            }
        });
        return useSilenceSound[0];
    }

    private long getCoolDown(IGun iGun, class_1799 mainHandItem, GunData gunData) {
        FireMode fireMode = iGun.getFireMode(mainHandItem);
        long coolDown = fireMode == FireMode.BURST ? (long)(gunData.getBurstData().getMinInterval() * 1000.0) - (System.currentTimeMillis() - this.data.clientShootTimestamp) : gunData.getShootInterval() - (System.currentTimeMillis() - this.data.clientShootTimestamp);
        return Math.max(coolDown, 0L);
    }

    public long getClientShootCoolDown() {
        class_1799 mainHandItem = this.player.method_6047();
        IGun iGun = IGun.getIGunOrNull(mainHandItem);
        if (iGun == null) {
            return -1L;
        }
        class_2960 gunId = iGun.getGunId(mainHandItem);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        return gunIndexOptional.map(commonGunIndex -> this.getCoolDown(iGun, mainHandItem, commonGunIndex.getGunData())).orElse(-1L);
    }
}

