/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.gui.components.refit;

import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.attachment.AttachmentType;
import com.imguns.guns.client.gui.GunRefitScreen;
import com.imguns.guns.client.gui.components.refit.IStackTooltip;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import org.jetbrains.annotations.NotNull;

public class GunAttachmentSlot
extends class_4185
implements IStackTooltip {
    private final AttachmentType type;
    private final class_1661 inventory;
    private final int gunItemIndex;
    private final String nameKey;
    private boolean selected = false;
    private class_1799 attachmentItem = class_1799.field_8037;

    public GunAttachmentSlot(int pX, int pY, AttachmentType type, int gunItemIndex, class_1661 inventory, class_4185.class_4241 onPress) {
        super(pX, pY, 18, 18, (class_2561)class_2561.method_43473(), onPress, class_4185.field_40754);
        this.type = type;
        this.inventory = inventory;
        this.gunItemIndex = gunItemIndex;
        this.nameKey = String.format("tooltip.immersive_guns.attachment.%s", type.name().toLowerCase(Locale.US));
    }

    @Override
    public void renderTooltip(Consumer<class_1799> consumer) {
        if (this.method_25367() && !this.attachmentItem.method_7960()) {
            consumer.accept(this.attachmentItem);
        }
    }

    public void method_48579(@NotNull class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        class_1799 gunItem;
        IGun iGun;
        if (this.method_25367()) {
            class_327 font = class_310.method_1551().field_1772;
            int yOffset = this.method_46427() + 20;
            if (this.selected && !this.attachmentItem.method_7960()) {
                yOffset = this.method_46427() + 30;
            }
            graphics.method_27534(font, (class_2561)class_2561.method_43471((String)this.nameKey), this.method_46426() + this.method_25368() / 2, yOffset, class_124.field_1068.method_532().intValue());
        }
        if ((iGun = IGun.getIGunOrNull(gunItem = this.inventory.method_5438(this.gunItemIndex))) == null) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        int x = this.method_46426();
        int y = this.method_46427();
        if (this.method_25367() || this.selected) {
            graphics.method_25290(GunRefitScreen.SLOT_TEXTURE, x, y, 0.0f, 0.0f, this.field_22758, this.field_22759, 18, 18);
        } else {
            graphics.method_25290(GunRefitScreen.SLOT_TEXTURE, x + 1, y + 1, 1.0f, 1.0f, this.field_22758 - 2, this.field_22759 - 2, 18, 18);
        }
        this.attachmentItem = iGun.getAttachment(gunItem, this.type);
        if (!this.attachmentItem.method_7960()) {
            graphics.method_51427(this.attachmentItem, x + 1, y + 1);
        } else {
            int xOffset = GunRefitScreen.getSlotTextureXOffset(gunItem, this.type);
            graphics.method_25293(GunRefitScreen.ICONS_TEXTURE, x + 2, y + 2, this.field_22758 - 4, this.field_22759 - 4, (float)xOffset, 0.0f, 32, 32, GunRefitScreen.getSlotsTextureWidth(), 32);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public AttachmentType getAttachmentType() {
        return this.type;
    }

    public class_1799 getAttachmentItem() {
        class_1799 gunItem = this.inventory.method_5438(this.gunItemIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return class_1799.field_8037;
        }
        return iGun.getAttachment(gunItem, this.type);
    }

    public boolean isAllow() {
        class_1799 gunItem = this.inventory.method_5438(this.gunItemIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return false;
        }
        return iGun.allowAttachmentType(gunItem, this.type);
    }
}

