/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.gui.components.refit;

import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.config.sync.SyncConfig;
import com.imguns.guns.resource.pojo.data.attachment.RecoilModifier;
import com.imguns.guns.resource.pojo.data.gun.Bolt;
import com.imguns.guns.resource.pojo.data.gun.BulletData;
import com.imguns.guns.resource.pojo.data.gun.GunData;
import com.imguns.guns.resource.pojo.data.gun.GunRecoil;
import com.imguns.guns.resource.pojo.data.gun.GunRecoilKeyFrame;
import com.imguns.guns.resource.pojo.data.gun.InaccuracyType;
import com.imguns.guns.util.AttachmentDataUtils;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;

public final class GunPropertyDiagrams {
    public static void draw(class_332 graphics, class_327 font, int x, int y) {
        graphics.method_25294(x, y, x + 258, y + 98, -1356717534);
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1799 gunItem = player.method_6047();
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }
        class_2960 gunId = iGun.getGunId(gunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(index -> {
            GunData gunData = index.getGunData();
            BulletData bulletData = gunData.getBulletData();
            GunRecoil recoil = gunData.getRecoil();
            int barStartX = x + 58;
            int barMaxWidth = 120;
            int barEndX = barStartX + barMaxWidth;
            int barBackgroundColor = -16777216;
            int barBaseColor = -1;
            int barPositivelyColor = -11141291;
            int barNegativeColor = -43691;
            int fontColor = 0xCCCCCC;
            int nameTextStartX = x + 5;
            int valueTextStartX = x + 185;
            double damageAmount = (double)bulletData.getDamageAmount() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get();
            double damagePercent = Math.min(Math.log(damageAmount) / 5.0, 1.0);
            int damageLength = (int)((double)barStartX + (double)barMaxWidth * damagePercent);
            String damageValueText = String.format("%.2f", damageAmount);
            graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.immersive_guns.gun_refit.property_diagrams.damage"), nameTextStartX, y + 5, fontColor, false);
            graphics.method_25294(barStartX, y + 7, barEndX, y + 11, barBackgroundColor);
            graphics.method_25294(barStartX, y + 7, damageLength, y + 11, barBaseColor);
            graphics.method_51433(font, damageValueText, valueTextStartX, y + 5, fontColor, false);
            int rpm = gunData.getRoundsPerMinute();
            double rpmPercent = Math.min((double)rpm / 1200.0, 1.0);
            int rpmLength = (int)((double)barStartX + (double)barMaxWidth * rpmPercent);
            String rpmValueText = String.format("%drpm", rpm);
            graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.immersive_guns.gun_refit.property_diagrams.rpm"), nameTextStartX, y + 15, fontColor, false);
            graphics.method_25294(barStartX, y + 17, barEndX, y + 21, barBackgroundColor);
            graphics.method_25294(barStartX, y + 17, rpmLength, y + 21, barBaseColor);
            graphics.method_51433(font, rpmValueText, valueTextStartX, y + 15, fontColor, false);
            float aimInaccuracy = gunData.getInaccuracy(InaccuracyType.AIM);
            double aimInaccuracyPercent = class_3532.method_15363((float)(1.0f - aimInaccuracy), (float)0.0f, (float)1.0f);
            int aimInaccuracyLength = (int)((double)barStartX + (double)barMaxWidth * aimInaccuracyPercent);
            String aimInaccuracyValueText = String.format("%.2f%%", aimInaccuracyPercent * 100.0);
            graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.immersive_guns.gun_refit.property_diagrams.accuracy"), nameTextStartX, y + 25, fontColor, false);
            graphics.method_25294(barStartX, y + 27, barEndX, y + 31, barBackgroundColor);
            graphics.method_25294(barStartX, y + 27, aimInaccuracyLength, y + 31, barBaseColor);
            graphics.method_51433(font, aimInaccuracyValueText, valueTextStartX, y + 25, fontColor, false);
            float standInaccuracy = gunData.getInaccuracy(InaccuracyType.STAND);
            double standInaccuracyPercent = Math.min((double)standInaccuracy / 10.0, 1.0);
            int inaccuracyLength = (int)((double)barStartX + (double)barMaxWidth * standInaccuracyPercent);
            float[] inaccuracyModifier = new float[]{0.0f};
            AttachmentDataUtils.getAllAttachmentData(gunItem, gunData, attachmentData -> {
                inaccuracyModifier[0] = inaccuracyModifier[0] + attachmentData.getInaccuracyAddend();
            });
            double attachmentInaccuracyPercent = Math.min((double)inaccuracyModifier[0] / 10.0, 1.0);
            int inaccuracyModifierLength = class_3532.method_15340((int)(inaccuracyLength + (int)((double)barMaxWidth * attachmentInaccuracyPercent)), (int)barStartX, (int)barEndX);
            graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.immersive_guns.gun_refit.property_diagrams.hipfire_inaccuracy"), nameTextStartX, y + 35, fontColor, false);
            graphics.method_25294(barStartX, y + 37, barEndX, y + 41, barBackgroundColor);
            graphics.method_25294(barStartX, y + 37, inaccuracyLength, y + 41, barBaseColor);
            if (attachmentInaccuracyPercent < 0.0) {
                graphics.method_25294(inaccuracyModifierLength, y + 37, inaccuracyLength, y + 41, barPositivelyColor);
                graphics.method_51433(font, String.format("%.2f \u00a7a(%.2f)", Float.valueOf(standInaccuracy), Float.valueOf(inaccuracyModifier[0])), valueTextStartX, y + 35, fontColor, false);
            } else if (attachmentInaccuracyPercent > 0.0) {
                graphics.method_25294(inaccuracyLength, y + 37, inaccuracyModifierLength, y + 41, barNegativeColor);
                graphics.method_51433(font, String.format("%.2f \u00a7c(+%.2f)", Float.valueOf(standInaccuracy), Float.valueOf(inaccuracyModifier[0])), valueTextStartX, y + 35, fontColor, false);
            } else {
                graphics.method_51433(font, String.format("%.2f", Float.valueOf(standInaccuracy)), valueTextStartX, y + 35, fontColor, false);
            }
            int barrelBulletAmount = iGun.hasBulletInBarrel(gunItem) && index.getGunData().getBolt() != Bolt.OPEN_BOLT ? 1 : 0;
            int ammoAmount = gunData.getAmmoAmount() + barrelBulletAmount;
            double ammoAmountPercent = Math.min((double)ammoAmount / 100.0, 1.0);
            int ammoLength = (int)((double)barStartX + (double)barMaxWidth * ammoAmountPercent);
            int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(gunItem, index.getGunData()) + barrelBulletAmount;
            int addAmmoCount = Math.max(maxAmmoCount - ammoAmount, 0);
            int addAmmoCountLength = (int)((double)(barMaxWidth * addAmmoCount) / 100.0);
            graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.immersive_guns.gun_refit.property_diagrams.ammo_capacity"), nameTextStartX, y + 45, fontColor, false);
            graphics.method_25294(barStartX, y + 47, barEndX, y + 51, barBackgroundColor);
            graphics.method_25294(barStartX, y + 47, ammoLength, y + 51, barBaseColor);
            if (addAmmoCount > 0) {
                int barRight = Math.min(ammoLength + addAmmoCountLength, barEndX);
                graphics.method_25294(ammoLength, y + 47, barRight, y + 51, barPositivelyColor);
                graphics.method_51433(font, String.format("%d \u00a7a(+%d)", ammoAmount, addAmmoCount), valueTextStartX, y + 45, fontColor, false);
            } else {
                graphics.method_51433(font, String.valueOf(ammoAmount), valueTextStartX, y + 45, fontColor, false);
            }
            float[] attachmentRecoilModifier = new float[]{0.0f, 0.0f};
            AttachmentDataUtils.getAllAttachmentData(gunItem, gunData, attachmentData -> {
                RecoilModifier recoilModifier = attachmentData.getRecoilModifier();
                if (recoilModifier == null) {
                    return;
                }
                attachmentRecoilModifier[0] = attachmentRecoilModifier[0] + recoilModifier.getPitch();
                attachmentRecoilModifier[1] = attachmentRecoilModifier[1] + recoilModifier.getYaw();
            });
            float yawRecoil = GunPropertyDiagrams.getMaxInGunRecoilKeyFrame(recoil.getYaw());
            double yawRecoilPercent = Math.min((double)yawRecoil / 5.0, 1.0);
            int yawLength = (int)((double)barStartX + (double)barMaxWidth * yawRecoilPercent);
            int yawModifierLength = class_3532.method_15340((int)(yawLength + (int)((double)((float)barMaxWidth * attachmentRecoilModifier[1]) / 5.0)), (int)barStartX, (int)barEndX);
            float pitchRecoil = GunPropertyDiagrams.getMaxInGunRecoilKeyFrame(recoil.getPitch());
            double pitchRecoilPercent = Math.min((double)pitchRecoil / 5.0, 1.0);
            int pitchLength = (int)((double)barStartX + (double)barMaxWidth * pitchRecoilPercent);
            int pitchModifierLength = class_3532.method_15340((int)(pitchLength + (int)((double)((float)barMaxWidth * attachmentRecoilModifier[0]) / 5.0)), (int)barStartX, (int)barEndX);
            graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.immersive_guns.gun_refit.property_diagrams.yaw"), nameTextStartX, y + 55, fontColor, false);
            graphics.method_25294(barStartX, y + 57, barEndX, y + 61, barBackgroundColor);
            graphics.method_25294(barStartX, y + 57, yawLength, y + 61, barBaseColor);
            if (attachmentRecoilModifier[1] > 0.0f) {
                graphics.method_25294(yawLength, y + 57, yawModifierLength, y + 61, barNegativeColor);
                graphics.method_51433(font, String.format("%.2f \u00a7c(+%.2f)", Float.valueOf(yawRecoil), Float.valueOf(attachmentRecoilModifier[1])), valueTextStartX, y + 55, fontColor, false);
            } else if (attachmentRecoilModifier[1] < 0.0f) {
                graphics.method_25294(yawModifierLength, y + 57, yawLength, y + 61, barPositivelyColor);
                graphics.method_51433(font, String.format("%.2f \u00a7a(%.2f)", Float.valueOf(yawRecoil), Float.valueOf(attachmentRecoilModifier[1])), valueTextStartX, y + 55, fontColor, false);
            } else {
                graphics.method_51433(font, String.valueOf(yawRecoil), valueTextStartX, y + 55, fontColor, false);
            }
            graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.immersive_guns.gun_refit.property_diagrams.pitch"), nameTextStartX, y + 65, fontColor, false);
            graphics.method_25294(barStartX, y + 67, barEndX, y + 71, barBackgroundColor);
            graphics.method_25294(barStartX, y + 67, pitchLength, y + 71, barBaseColor);
            if (attachmentRecoilModifier[0] > 0.0f) {
                graphics.method_25294(pitchLength, y + 67, pitchModifierLength, y + 71, barNegativeColor);
                graphics.method_51433(font, String.format("%.2f \u00a7c(+%.2f)", Float.valueOf(pitchRecoil), Float.valueOf(attachmentRecoilModifier[0])), valueTextStartX, y + 65, fontColor, false);
            } else if (attachmentRecoilModifier[0] < 0.0f) {
                graphics.method_25294(pitchModifierLength, y + 67, pitchLength, y + 71, barPositivelyColor);
                graphics.method_51433(font, String.format("%.2f \u00a7a(%.2f)", Float.valueOf(pitchRecoil), Float.valueOf(attachmentRecoilModifier[0])), valueTextStartX, y + 65, fontColor, false);
            } else {
                graphics.method_51433(font, String.valueOf(pitchRecoil), valueTextStartX, y + 65, fontColor, false);
            }
            float[] adsTimeModifier = new float[]{0.0f};
            AttachmentDataUtils.getAllAttachmentData(gunItem, gunData, attachmentData -> {
                adsTimeModifier[0] = adsTimeModifier[0] + attachmentData.getAdsAddendTime();
            });
            float aimTime = gunData.getAimTime();
            double aimTimePercent = Math.min(aimTime, 1.0f);
            int aimeTimeLength = (int)((double)barStartX + (double)barMaxWidth * aimTimePercent);
            int adsModifierLength = class_3532.method_15340((int)(aimeTimeLength + (int)((float)barMaxWidth * adsTimeModifier[0])), (int)barStartX, (int)barEndX);
            graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.immersive_guns.gun_refit.property_diagrams.ads"), nameTextStartX, y + 75, fontColor, false);
            graphics.method_25294(barStartX, y + 77, barEndX, y + 81, barBackgroundColor);
            graphics.method_25294(barStartX, y + 77, aimeTimeLength, y + 81, barBaseColor);
            if (adsTimeModifier[0] > 0.0f) {
                graphics.method_25294(aimeTimeLength, y + 77, adsModifierLength, y + 81, barNegativeColor);
                graphics.method_51433(font, String.format("%.2fs \u00a7c(+%.2f)", Float.valueOf(pitchRecoil), Float.valueOf(adsTimeModifier[0])), valueTextStartX, y + 75, fontColor, false);
            } else if (adsTimeModifier[0] < 0.0f) {
                graphics.method_25294(adsModifierLength, y + 77, aimeTimeLength, y + 81, barPositivelyColor);
                graphics.method_51433(font, String.format("%.2fs \u00a7a(%.2f)", Float.valueOf(pitchRecoil), Float.valueOf(adsTimeModifier[0])), valueTextStartX, y + 75, fontColor, false);
            } else {
                graphics.method_51433(font, String.valueOf(aimTime), valueTextStartX, y + 75, fontColor, false);
            }
            float sprintTime = gunData.getSprintTime();
            double sprintTimePercent = class_3532.method_15363((float)aimTime, (float)0.0f, (float)1.0f);
            int sprintLength = (int)((double)barStartX + (double)barMaxWidth * sprintTimePercent);
            String sprintValueText = String.format("%.2fs", Float.valueOf(sprintTime));
            graphics.method_51439(font, (class_2561)class_2561.method_43471((String)"gui.immersive_guns.gun_refit.property_diagrams.sprint_time"), nameTextStartX, y + 85, fontColor, false);
            graphics.method_25294(barStartX, y + 87, barEndX, y + 91, barBackgroundColor);
            graphics.method_25294(barStartX, y + 87, sprintLength, y + 91, barBaseColor);
            graphics.method_51433(font, sprintValueText, valueTextStartX, y + 85, fontColor, false);
        });
    }

    private static float getMaxInGunRecoilKeyFrame(GunRecoilKeyFrame[] frames) {
        if (frames.length == 0) {
            return 0.0f;
        }
        float[] value = frames[0].getValue();
        float leftValue = Math.abs(value[0]);
        float rightValue = Math.abs(value[1]);
        return Math.max(leftValue, rightValue);
    }
}

