/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.model.bedrock;

import com.imguns.guns.client.model.bedrock.BedrockCube;
import com.imguns.guns.client.model.bedrock.BedrockPolygon;
import com.imguns.guns.client.model.bedrock.BedrockVertex;
import com.imguns.guns.client.resource.pojo.model.FaceItem;
import com.imguns.guns.client.resource.pojo.model.FaceUVsItem;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class BedrockCubePerFace
implements BedrockCube {
    private static final BedrockVertex EMPTY = new BedrockVertex(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    private static final BedrockVertex[] EMPTY_VERTEX = new BedrockVertex[]{EMPTY, EMPTY, EMPTY, EMPTY};
    public final float minX;
    public final float minY;
    public final float minZ;
    public final float maxX;
    public final float maxY;
    public final float maxZ;
    private final BedrockPolygon[] polygons;

    public BedrockCubePerFace(float x, float y, float z, float width, float height, float depth, float delta, float texWidth, float texHeight, FaceUVsItem faces) {
        this.minX = x;
        this.minY = y;
        this.minZ = z;
        this.maxX = x + width;
        this.maxY = y + height;
        this.maxZ = z + depth;
        this.polygons = new BedrockPolygon[6];
        float xEnd = x + width;
        float yEnd = y + height;
        float zEnd = z + depth;
        BedrockVertex vertex1 = new BedrockVertex(x -= delta, y -= delta, z -= delta, 0.0f, 0.0f);
        BedrockVertex vertex2 = new BedrockVertex(xEnd += delta, y, z, 0.0f, 8.0f);
        BedrockVertex vertex3 = new BedrockVertex(xEnd, yEnd += delta, z, 8.0f, 8.0f);
        BedrockVertex vertex4 = new BedrockVertex(x, yEnd, z, 8.0f, 0.0f);
        BedrockVertex vertex5 = new BedrockVertex(x, y, zEnd += delta, 0.0f, 0.0f);
        BedrockVertex vertex6 = new BedrockVertex(xEnd, y, zEnd, 0.0f, 8.0f);
        BedrockVertex vertex7 = new BedrockVertex(xEnd, yEnd, zEnd, 8.0f, 8.0f);
        BedrockVertex vertex8 = new BedrockVertex(x, yEnd, zEnd, 8.0f, 0.0f);
        this.polygons[2] = this.getTexturedQuad(new BedrockVertex[]{vertex6, vertex5, vertex1, vertex2}, texWidth, texHeight, class_2350.field_11033, faces);
        this.polygons[3] = this.getTexturedQuad(new BedrockVertex[]{vertex3, vertex4, vertex8, vertex7}, texWidth, texHeight, class_2350.field_11036, faces);
        this.polygons[1] = this.getTexturedQuad(new BedrockVertex[]{vertex1, vertex5, vertex8, vertex4}, texWidth, texHeight, class_2350.field_11039, faces);
        this.polygons[4] = this.getTexturedQuad(new BedrockVertex[]{vertex2, vertex1, vertex4, vertex3}, texWidth, texHeight, class_2350.field_11043, faces);
        this.polygons[0] = this.getTexturedQuad(new BedrockVertex[]{vertex6, vertex2, vertex3, vertex7}, texWidth, texHeight, class_2350.field_11034, faces);
        this.polygons[5] = this.getTexturedQuad(new BedrockVertex[]{vertex5, vertex6, vertex7, vertex8}, texWidth, texHeight, class_2350.field_11035, faces);
    }

    private BedrockPolygon getTexturedQuad(BedrockVertex[] positionsIn, float texWidth, float texHeight, class_2350 direction, FaceUVsItem faces) {
        FaceItem face = faces.getFace(direction);
        float u1 = face.getUv()[0];
        float v1 = face.getUv()[1];
        float u2 = u1 + face.getUvSize()[0];
        float v2 = v1 + face.getUvSize()[1];
        if (face == FaceItem.EMPTY) {
            return new BedrockPolygon(EMPTY_VERTEX, u1, v1, u2, v2, texWidth, texHeight, false, direction);
        }
        return new BedrockPolygon(positionsIn, u1, v1, u2, v2, texWidth, texHeight, false, direction);
    }

    @Override
    public void compile(class_4587.class_4665 entry, class_4588 consumer, int light, int overlay, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = entry.method_23761();
        Matrix3f matrix3f = entry.method_23762();
        for (BedrockPolygon polygon : this.polygons) {
            Vector3f vector3f = new Vector3f((Vector3fc)polygon.normal);
            vector3f.mul((Matrix3fc)matrix3f);
            float nx = vector3f.x();
            float ny = vector3f.y();
            float nz = vector3f.z();
            for (BedrockVertex vertex : polygon.vertices) {
                float x = vertex.pos.x() / 16.0f;
                float y = vertex.pos.y() / 16.0f;
                float z = vertex.pos.z() / 16.0f;
                Vector4f vector4f = new Vector4f(x, y, z, 1.0f);
                vector4f.mul((Matrix4fc)matrix4f);
                consumer.method_23919(vector4f.x(), vector4f.y(), vector4f.z(), red, green, blue, alpha, vertex.u, vertex.v, overlay, light, nx, ny, nz);
            }
        }
    }
}

