/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.model.bedrock;

import com.imguns.guns.client.model.IFunctionalRenderer;
import com.imguns.guns.client.model.bedrock.BedrockCubeBox;
import com.imguns.guns.client.model.bedrock.BedrockCubePerFace;
import com.imguns.guns.client.model.bedrock.BedrockPart;
import com.imguns.guns.client.model.bedrock.ModelRendererWrapper;
import com.imguns.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.imguns.guns.client.resource.pojo.model.BedrockVersion;
import com.imguns.guns.client.resource.pojo.model.BonesItem;
import com.imguns.guns.client.resource.pojo.model.CubesItem;
import com.imguns.guns.client.resource.pojo.model.Description;
import com.imguns.guns.client.resource.pojo.model.FaceUVsItem;
import com.imguns.guns.compat.iris.IrisCompat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class BedrockModel {
    public static BedrockModel dummyModel = new BedrockModel();
    protected final HashMap<String, ModelRendererWrapper> modelMap = new HashMap();
    protected final HashMap<String, BonesItem> indexBones = new HashMap();
    protected final List<BedrockPart> shouldRender = new LinkedList<BedrockPart>();
    protected List<IFunctionalRenderer> delegateRenderers = new ArrayList<IFunctionalRenderer>();
    @Nullable
    protected class_243 offset = null;
    @Nullable
    protected class_241 size = null;

    public BedrockModel(BedrockModelPOJO pojo, BedrockVersion version) {
        if (version == BedrockVersion.LEGACY) {
            this.loadLegacyModel(pojo);
        }
        if (version == BedrockVersion.NEW) {
            this.loadNewModel(pojo);
        }
        for (ModelRendererWrapper rendererWrapper : this.modelMap.values()) {
            if (rendererWrapper.modelRenderer().name == null || !rendererWrapper.modelRenderer().name.endsWith("_illuminated")) continue;
            rendererWrapper.modelRenderer().illuminated = true;
        }
    }

    protected BedrockModel() {
    }

    public void delegateRender(IFunctionalRenderer renderer) {
        this.delegateRenderers.add(renderer);
    }

    private void setRotationAngle(BedrockPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
        modelRenderer.setInitRotationAngle(x, y, z);
    }

    protected void loadNewModel(BedrockModelPOJO pojo) {
        assert (pojo.getGeometryModelNew() != null);
        pojo.getGeometryModelNew().deco();
        if (pojo.getGeometryModelNew().getBones() == null) {
            return;
        }
        Description description = pojo.getGeometryModelNew().getDescription();
        int texWidth = description.getTextureWidth();
        int texHeight = description.getTextureHeight();
        List<Float> offset = description.getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        this.offset = new class_243((double)offsetX, (double)offsetY, (double)offsetZ);
        float width = description.getVisibleBoundsWidth() / 2.0f;
        float height = description.getVisibleBoundsHeight() / 2.0f;
        this.size = new class_241(width, height);
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            this.indexBones.putIfAbsent(bones.getName(), bones);
            this.modelMap.putIfAbsent(bones.getName(), new ModelRendererWrapper(new BedrockPart(bones.getName())));
        }
        for (BonesItem bones : pojo.getGeometryModelNew().getBones()) {
            String name = bones.getName();
            @Nullable List<Float> rotation = bones.getRotation();
            @Nullable String parent = bones.getParent();
            BedrockPart model = this.modelMap.get(name).modelRenderer();
            model.mirror = bones.isMirror();
            model.setPos(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation.get(0).floatValue()), this.convertRotation(rotation.get(1).floatValue()), this.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                BedrockPart parentPart = this.modelMap.get(parent).modelRenderer();
                parentPart.addChild(model);
                model.parent = parentPart;
            } else {
                this.shouldRender.add(model);
                model.parent = null;
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                @Nullable FaceUVsItem faceUv = cube.getFaceUv();
                List<Float> size = cube.getSize();
                @Nullable List<Float> cubeRotation = cube.getRotation();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                if (cubeRotation == null) {
                    if (faceUv == null) {
                        model.cubes.add((Object)new BedrockCubeBox(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, texWidth, texHeight));
                        continue;
                    }
                    model.cubes.add((Object)new BedrockCubePerFace(this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, texWidth, texHeight, faceUv));
                    continue;
                }
                BedrockPart cubeRenderer = new BedrockPart(null);
                cubeRenderer.setPos(this.convertPivot(bones, cube, 0), this.convertPivot(bones, cube, 1), this.convertPivot(bones, cube, 2));
                this.setRotationAngle(cubeRenderer, this.convertRotation(cubeRotation.get(0).floatValue()), this.convertRotation(cubeRotation.get(1).floatValue()), this.convertRotation(cubeRotation.get(2).floatValue()));
                if (faceUv == null) {
                    cubeRenderer.cubes.add((Object)new BedrockCubeBox(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, texWidth, texHeight));
                } else {
                    cubeRenderer.cubes.add((Object)new BedrockCubePerFace(this.convertOrigin(cube, 0), this.convertOrigin(cube, 1), this.convertOrigin(cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, texWidth, texHeight, faceUv));
                }
                model.addChild(cubeRenderer);
            }
        }
    }

    protected void loadLegacyModel(BedrockModelPOJO pojo) {
        assert (pojo.getGeometryModelLegacy() != null);
        pojo.getGeometryModelLegacy().deco();
        if (pojo.getGeometryModelLegacy().getBones() == null) {
            return;
        }
        int texWidth = pojo.getGeometryModelLegacy().getTextureWidth();
        int texHeight = pojo.getGeometryModelLegacy().getTextureHeight();
        List<Float> offset = pojo.getGeometryModelLegacy().getVisibleBoundsOffset();
        float offsetX = offset.get(0).floatValue();
        float offsetY = offset.get(1).floatValue();
        float offsetZ = offset.get(2).floatValue();
        this.offset = new class_243((double)offsetX, (double)offsetY, (double)offsetZ);
        float width = pojo.getGeometryModelLegacy().getVisibleBoundsWidth() / 2.0f;
        float height = pojo.getGeometryModelLegacy().getVisibleBoundsHeight() / 2.0f;
        this.size = new class_241(width, height);
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            this.indexBones.putIfAbsent(bones.getName(), bones);
            this.modelMap.putIfAbsent(bones.getName(), new ModelRendererWrapper(new BedrockPart(bones.getName())));
        }
        for (BonesItem bones : pojo.getGeometryModelLegacy().getBones()) {
            String name = bones.getName();
            @Nullable List<Float> rotation = bones.getRotation();
            @Nullable String parent = bones.getParent();
            BedrockPart model = this.modelMap.get(name).modelRenderer();
            model.mirror = bones.isMirror();
            model.setPos(this.convertPivot(bones, 0), this.convertPivot(bones, 1), this.convertPivot(bones, 2));
            if (rotation != null) {
                this.setRotationAngle(model, this.convertRotation(rotation.get(0).floatValue()), this.convertRotation(rotation.get(1).floatValue()), this.convertRotation(rotation.get(2).floatValue()));
            }
            if (parent != null) {
                this.modelMap.get(parent).modelRenderer().addChild(model);
            } else {
                this.shouldRender.add(model);
            }
            if (bones.getCubes() == null) continue;
            for (CubesItem cube : bones.getCubes()) {
                List<Float> uv = cube.getUv();
                List<Float> size = cube.getSize();
                boolean mirror = cube.isMirror();
                float inflate = cube.getInflate();
                model.cubes.add((Object)new BedrockCubeBox(uv.get(0).floatValue(), uv.get(1).floatValue(), this.convertOrigin(bones, cube, 0), this.convertOrigin(bones, cube, 1), this.convertOrigin(bones, cube, 2), size.get(0).floatValue(), size.get(1).floatValue(), size.get(2).floatValue(), inflate, mirror, texWidth, texHeight));
            }
        }
    }

    protected float convertPivot(BonesItem bones, int index) {
        if (bones.getParent() != null) {
            if (index == 1) {
                return this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue() - bones.getPivot().get(index).floatValue();
            }
            return bones.getPivot().get(index).floatValue() - this.indexBones.get(bones.getParent()).getPivot().get(index).floatValue();
        }
        if (index == 1) {
            return 24.0f - bones.getPivot().get(index).floatValue();
        }
        return bones.getPivot().get(index).floatValue();
    }

    protected float convertPivot(BonesItem parent, CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return parent.getPivot().get(index).floatValue() - cube.getPivot().get(index).floatValue();
        }
        return cube.getPivot().get(index).floatValue() - parent.getPivot().get(index).floatValue();
    }

    protected float convertOrigin(BonesItem bone, CubesItem cube, int index) {
        if (index == 1) {
            return bone.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - bone.getPivot().get(index).floatValue();
    }

    protected float convertOrigin(CubesItem cube, int index) {
        assert (cube.getPivot() != null);
        if (index == 1) {
            return cube.getPivot().get(index).floatValue() - cube.getOrigin().get(index).floatValue() - cube.getSize().get(index).floatValue();
        }
        return cube.getOrigin().get(index).floatValue() - cube.getPivot().get(index).floatValue();
    }

    protected float convertRotation(float degree) {
        return (float)((double)degree * Math.PI / 180.0);
    }

    public BedrockPart getNode(String nodeName) {
        ModelRendererWrapper rendererWrapper = this.modelMap.get(nodeName);
        if (rendererWrapper != null) {
            return rendererWrapper.modelRenderer();
        }
        return null;
    }

    public BonesItem getBone(String name) {
        return this.indexBones.get(name);
    }

    public void render(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay) {
        this.render(matrixStack, transformType, renderType, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(class_4587 matrixStack, class_811 transformType, class_1921 renderType, int light, int overlay, float red, float green, float blue, float alpha) {
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 builder = bufferSource.getBuffer(renderType);
        matrixStack.method_22903();
        for (BedrockPart model : this.shouldRender) {
            model.render(matrixStack, transformType, builder, light, overlay, red, green, blue, alpha);
        }
        matrixStack.method_22909();
        if (IrisCompat.endBatch(bufferSource)) {
            bufferSource.method_22994(renderType);
        }
        for (IFunctionalRenderer renderer : this.delegateRenderers) {
            renderer.render(matrixStack, builder, transformType, light, overlay);
        }
        this.delegateRenderers = new ArrayList<IFunctionalRenderer>();
    }

    protected List<BedrockPart> getPath(@Nullable ModelRendererWrapper rendererWrapper) {
        if (rendererWrapper == null) {
            return null;
        }
        BedrockPart part = rendererWrapper.modelRenderer();
        ArrayList<BedrockPart> path = new ArrayList<BedrockPart>();
        Stack<BedrockPart> stack = new Stack<BedrockPart>();
        do {
            stack.push(part);
        } while ((part = part.getParent()) != null);
        while (!stack.isEmpty()) {
            part = (BedrockPart)stack.pop();
            path.add(part);
        }
        return path;
    }

    @Nullable
    public class_243 getOffset() {
        return this.offset;
    }

    @Nullable
    public class_241 getSize() {
        return this.size;
    }

    public List<BedrockPart> getShouldRender() {
        return this.shouldRender;
    }

    public HashMap<String, BonesItem> getIndexBones() {
        return this.indexBones;
    }
}

