/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.model.listener.constraint;

import com.imguns.guns.api.client.animation.AnimationListener;
import com.imguns.guns.api.client.animation.ObjectAnimationChannel;
import com.imguns.guns.client.model.listener.constraint.ConstraintObject;

public class ConstraintTranslateListener
implements AnimationListener {
    private final ConstraintObject constraint;

    public ConstraintTranslateListener(ConstraintObject constraint) {
        this.constraint = constraint;
    }

    @Override
    public void update(float[] values, boolean blend) {
        if (blend) {
            this.constraint.translationConstraint.set(Math.max(this.constraint.translationConstraint.x(), values[0] * 16.0f), Math.max(this.constraint.translationConstraint.y(), values[1] * 16.0f), Math.max(this.constraint.translationConstraint.z(), values[2] * 16.0f));
        } else {
            this.constraint.translationConstraint.set(values[0] * 16.0f, values[1] * 16.0f, values[2] * 16.0f);
        }
    }

    @Override
    public float[] initialValue() {
        float[] recover = new float[3];
        if (this.constraint.bonesItem != null) {
            recover[0] = this.constraint.bonesItem.getPivot().get(0).floatValue() / 16.0f;
            recover[1] = -this.constraint.bonesItem.getPivot().get(1).floatValue() / 16.0f;
            recover[2] = this.constraint.bonesItem.getPivot().get(2).floatValue() / 16.0f;
        } else {
            recover[0] = this.constraint.node.x / 16.0f;
            recover[1] = this.constraint.node.y / 16.0f;
            recover[2] = this.constraint.node.z / 16.0f;
        }
        return recover;
    }

    @Override
    public ObjectAnimationChannel.ChannelType getType() {
        return ObjectAnimationChannel.ChannelType.TRANSLATION;
    }
}

