/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.model.listener.model;

import com.imguns.guns.api.client.animation.AnimationListener;
import com.imguns.guns.api.client.animation.ObjectAnimationChannel;
import com.imguns.guns.client.model.BedrockAnimatedModel;
import com.imguns.guns.client.model.bedrock.ModelRendererWrapper;
import com.imguns.guns.client.resource.pojo.model.BonesItem;
import org.jetbrains.annotations.Nullable;

public class ModelTranslateListener
implements AnimationListener {
    private final ModelRendererWrapper rendererWrapper;
    @Nullable
    private final BonesItem bonesItem;

    public ModelTranslateListener(BedrockAnimatedModel model, ModelRendererWrapper rendererWrapper, String nodeName) {
        this.rendererWrapper = rendererWrapper;
        this.bonesItem = model.getShouldRender().contains(rendererWrapper.modelRenderer()) ? model.getIndexBones().get(nodeName) : null;
    }

    @Override
    public void update(float[] values, boolean blend) {
        if (blend) {
            this.rendererWrapper.addOffsetX(values[0]);
            this.rendererWrapper.addOffsetY(-values[1]);
            this.rendererWrapper.addOffsetZ(values[2]);
        } else {
            this.rendererWrapper.setOffsetX(values[0]);
            this.rendererWrapper.setOffsetY(-values[1]);
            this.rendererWrapper.setOffsetZ(values[2]);
        }
    }

    @Override
    public float[] initialValue() {
        float[] recover = new float[3];
        if (this.bonesItem != null) {
            recover[0] = this.bonesItem.getPivot().get(0).floatValue() / 16.0f;
            recover[1] = -this.bonesItem.getPivot().get(1).floatValue() / 16.0f;
            recover[2] = this.bonesItem.getPivot().get(2).floatValue() / 16.0f;
        } else {
            recover[0] = this.rendererWrapper.getRotationPointX() / 16.0f;
            recover[1] = this.rendererWrapper.getRotationPointY() / 16.0f;
            recover[2] = this.rendererWrapper.getRotationPointZ() / 16.0f;
        }
        return recover;
    }

    @Override
    public ObjectAnimationChannel.ChannelType getType() {
        return ObjectAnimationChannel.ChannelType.TRANSLATION;
    }
}

