/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.particle;

import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.client.resource.pojo.display.ammo.AmmoParticle;
import com.imguns.guns.entity.EntityKineticBullet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class AmmoParticleSpawner {
    public static void addParticle(EntityKineticBullet bullet, class_2960 gunId) {
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            AmmoParticle gunParticle = gunIndex.getParticle();
            if (gunParticle == null) {
                TimelessAPI.getClientAmmoIndex(bullet.getAmmoId()).ifPresent(ammoIndex -> {
                    AmmoParticle ammoParticle = ammoIndex.getParticle();
                    if (ammoParticle == null) {
                        return;
                    }
                    AmmoParticleSpawner.spawnParticle(bullet, ammoParticle);
                });
            } else {
                AmmoParticleSpawner.spawnParticle(bullet, gunParticle);
            }
        });
    }

    private static void spawnParticle(EntityKineticBullet bullet, AmmoParticle particle) {
        class_2394 particleEffect = particle.getParticleOptions();
        if (particleEffect == null) {
            return;
        }
        int count = particle.getCount();
        Vector3f delta = particle.getDelta();
        float particleSpeed = particle.getSpeed();
        class_702 particleManager = class_310.method_1551().field_1713;
        if (count == 0) {
            double xSpeed = particleSpeed * delta.x();
            double ySpeed = particleSpeed * delta.y();
            double zSpeed = particleSpeed * delta.z();
            class_703 result = particleManager.method_3056(particleEffect, bullet.method_23317(), bullet.method_23318(), bullet.method_23321(), xSpeed, ySpeed, zSpeed);
            if (result != null) {
                result.method_3077(particle.getLifeTime());
            }
        } else {
            class_5819 random = bullet.getRandom();
            class_1297 owner = bullet.method_24921();
            for (int i = 0; i < count; ++i) {
                AmmoParticleSpawner.createParticle(bullet, particle, random, delta, particleSpeed, owner, particleManager, particleEffect);
            }
        }
    }

    private static void createParticle(EntityKineticBullet bullet, AmmoParticle particle, class_5819 random, Vector3f delta, float particleSpeed, class_1297 owner, class_702 particleManager, class_2394 particleEffect) {
        class_703 result;
        class_243 deltaMovement = bullet.method_18798();
        double deltaMovementRandom = random.method_43058();
        double offsetX = random.method_43059() * (double)delta.x() + deltaMovementRandom * deltaMovement.field_1352;
        double offsetY = random.method_43059() * (double)delta.y() + deltaMovementRandom * deltaMovement.field_1351;
        double offsetZ = random.method_43059() * (double)delta.z() + deltaMovementRandom * deltaMovement.field_1350;
        double xSpeed = random.method_43059() * (double)particleSpeed;
        double ySpeed = random.method_43059() * (double)particleSpeed;
        double zSpeed = random.method_43059() * (double)particleSpeed;
        double posX = bullet.method_23317() + offsetX;
        double posY = bullet.method_23318() + offsetY;
        double posZ = bullet.method_23321() + offsetZ;
        if ((owner == null || owner.method_5649(posX, posY, posZ) > 9.0) && (result = particleManager.method_3056(particleEffect, posX, posY, posZ, xSpeed, ySpeed, zSpeed)) != null) {
            result.method_3077(particle.getLifeTime());
        }
    }
}

