/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.particle;

import com.imguns.guns.config.client.RenderConfig;
import com.imguns.guns.particles.BulletHoleOption;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_707;
import net.minecraft.class_765;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BulletHoleParticle
extends class_4003 {
    private final class_2350 direction;
    private final class_2338 pos;
    private int uOffset;
    private int vOffset;
    private float textureDensity;

    public BulletHoleParticle(class_638 world, double x, double y, double z, class_2350 direction, class_2338 pos, String ammoId, String gunId) {
        super(world, x, y, z);
        this.method_18141(this.getSprite(pos));
        this.direction = direction;
        this.pos = pos;
        this.field_3847 = this.getLifetimeFromConfig(world);
        this.field_3862 = false;
        this.field_3844 = 0.0f;
        this.field_17867 = 0.05f;
    }

    private int getLifetimeFromConfig(class_638 world) {
        int configLife = (Integer)RenderConfig.BULLET_HOLE_PARTICLE_LIFE.get();
        if (configLife <= 1) {
            return configLife;
        }
        return configLife + world.field_9229.method_43048(configLife / 2);
    }

    protected void method_18141(class_1058 sprite) {
        super.method_18141(sprite);
        this.uOffset = this.field_3840.method_43048(16);
        this.vOffset = this.field_3840.method_43048(16);
        this.textureDensity = (sprite.method_4577() - sprite.method_4594()) / 16.0f;
    }

    private class_1058 getSprite(class_2338 pos) {
        class_310 minecraft = class_310.method_1551();
        class_638 world = minecraft.field_1687;
        if (world != null) {
            class_2680 state = world.method_8320(pos);
            return class_310.method_1551().method_1541().method_3351().method_3339(state);
        }
        return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
    }

    protected float method_18133() {
        return this.field_17886.method_4594() + (float)this.uOffset * this.textureDensity;
    }

    protected float method_18135() {
        return this.field_17886.method_4593() + (float)this.vOffset * this.textureDensity;
    }

    protected float method_18134() {
        return this.method_18133() + this.textureDensity;
    }

    protected float method_18136() {
        return this.method_18135() + this.textureDensity;
    }

    public void method_3070() {
        super.method_3070();
        if (this.field_3851.method_8320(this.pos).method_26215()) {
            this.method_3085();
        }
    }

    public void method_3074(class_4588 buffer, class_4184 renderInfo, float partialTicks) {
        class_243 view = renderInfo.method_19326();
        float particleX = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - view.method_10216());
        float particleY = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - view.method_10214());
        float particleZ = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - view.method_10215());
        Quaternionf quaternion = this.direction.method_23224();
        Vector3f[] points = new Vector3f[]{new Vector3f(-1.0f, 0.01f, -1.0f), new Vector3f(-1.0f, 0.01f, 1.0f), new Vector3f(1.0f, 0.01f, 1.0f), new Vector3f(1.0f, 0.01f, -1.0f)};
        float scale = this.method_18132(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = points[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(scale);
            vector3f.add(particleX, particleY, particleZ);
        }
        float u0 = this.method_18133();
        float u1 = this.method_18134();
        float v0 = this.method_18135();
        float v1 = this.method_18136();
        int light = Math.max(15 - this.field_3866 / 2, 0);
        int lightColor = class_765.method_23687((int)light, (int)light);
        float colorPercent = (float)light / 15.0f;
        float red = this.field_3861 * colorPercent;
        float green = this.field_3842 * colorPercent;
        float blue = this.field_3859 * colorPercent;
        double threshold = (Double)RenderConfig.BULLET_HOLE_PARTICLE_FADE_THRESHOLD.get() * (double)this.field_3847;
        float fade = 1.0f - (float)(Math.max((double)this.field_3866 - threshold, 0.0) / ((double)this.field_3847 - threshold));
        float alphaFade = this.field_3841 * fade;
        buffer.method_22912((double)points[0].x(), (double)points[0].y(), (double)points[0].z()).method_22913(u1, v1).method_22915(red, green, blue, alphaFade).method_22916(lightColor).method_1344();
        buffer.method_22912((double)points[1].x(), (double)points[1].y(), (double)points[1].z()).method_22913(u1, v0).method_22915(red, green, blue, alphaFade).method_22916(lightColor).method_1344();
        buffer.method_22912((double)points[2].x(), (double)points[2].y(), (double)points[2].z()).method_22913(u0, v0).method_22915(red, green, blue, alphaFade).method_22916(lightColor).method_1344();
        buffer.method_22912((double)points[3].x(), (double)points[3].y(), (double)points[3].z()).method_22913(u0, v1).method_22915(red, green, blue, alphaFade).method_22916(lightColor).method_1344();
    }

    public class_3999 method_18122() {
        return class_3999.field_17827;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Provider
    implements class_707<BulletHoleOption> {
        public BulletHoleParticle createParticle(@NotNull BulletHoleOption option, @NotNull class_638 world, double x, double y, double z, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new BulletHoleParticle(world, x, y, z, option.getDirection(), option.getPos(), option.getAmmoId(), option.getGunId());
        }
    }
}

