/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.renderer.item;

import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.client.model.BedrockGunModel;
import com.imguns.guns.client.model.SlotModel;
import com.imguns.guns.client.model.bedrock.BedrockPart;
import com.imguns.guns.client.resource.pojo.TransformScale;
import com.imguns.guns.util.RenderDistance;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.minecraft.class_1047;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;

public class GunItemRenderer
implements BuiltinItemRendererRegistry.DynamicItemRenderer {
    private static final SlotModel SLOT_GUN_MODEL = new SlotModel();

    private static void applyPositioningNodeTransform(List<BedrockPart> nodePath, class_4587 poseStack, Vector3f scale) {
        if (nodePath == null) {
            return;
        }
        if (scale == null) {
            scale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        poseStack.method_22904(0.0, 1.5, 0.0);
        for (int i = nodePath.size() - 1; i >= 0; --i) {
            BedrockPart t = nodePath.get(i);
            poseStack.method_22907(class_7833.field_40713.rotation(t.xRot));
            poseStack.method_22907(class_7833.field_40715.rotation(t.yRot));
            poseStack.method_22907(class_7833.field_40717.rotation(t.zRot));
            if (t.getParent() != null) {
                poseStack.method_46416(-t.x * scale.x() / 16.0f, -t.y * scale.y() / 16.0f, -t.z * scale.z() / 16.0f);
                continue;
            }
            poseStack.method_46416(-t.x * scale.x() / 16.0f, (1.5f - t.y / 16.0f) * scale.y(), -t.z * scale.z() / 16.0f);
        }
        poseStack.method_22904(0.0, -1.5, 0.0);
    }

    public void render(class_1799 stack, class_811 transformType, class_4587 poseStack, class_4597 pBuffer, int pPackedLight, int pPackedOverlay) {
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(stack);
        poseStack.method_22903();
        TimelessAPI.getClientGunIndex(gunId).ifPresentOrElse(gunIndex -> {
            class_2960 gunTexture;
            BedrockGunModel gunModel;
            if (transformType == class_811.field_4321 || transformType == class_811.field_4322) {
                return;
            }
            if (transformType == class_811.field_4323) {
                return;
            }
            if (transformType == class_811.field_4317) {
                poseStack.method_22904(0.5, 1.5, 0.5);
                poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
                class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580((class_2960)gunIndex.getSlotTexture()));
                SLOT_GUN_MODEL.method_2828(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                return;
            }
            Pair<BedrockGunModel, class_2960> lodModel = gunIndex.getLodModel();
            if (lodModel == null || RenderDistance.inRenderHighPolyModelDistance(poseStack)) {
                gunModel = gunIndex.getGunModel();
                gunTexture = gunIndex.getModelTexture();
            } else {
                gunModel = (BedrockGunModel)lodModel.getLeft();
                gunTexture = (class_2960)lodModel.getRight();
            }
            poseStack.method_22904(0.5, 2.0, 0.5);
            poseStack.method_22905(-1.0f, -1.0f, 1.0f);
            this.applyPositioningTransform(transformType, gunIndex.getTransform().getScale(), gunModel, poseStack);
            this.applyScaleTransform(transformType, gunIndex.getTransform().getScale(), poseStack);
            class_1921 renderType = class_1921.method_23576((class_2960)gunTexture);
            gunModel.render(poseStack, stack, transformType, renderType, pPackedLight, pPackedOverlay);
        }, () -> {
            poseStack.method_22904(0.5, 1.5, 0.5);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(180.0f));
            class_4588 buffer = pBuffer.getBuffer(class_1921.method_23580((class_2960)class_1047.method_4539()));
            SLOT_GUN_MODEL.method_2828(poseStack, buffer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        });
        poseStack.method_22909();
    }

    private void applyPositioningTransform(class_811 transformType, TransformScale scale, BedrockGunModel model, class_4587 poseStack) {
        switch (transformType) {
            case field_4319: {
                GunItemRenderer.applyPositioningNodeTransform(model.getFixedOriginPath(), poseStack, scale.getFixed());
                break;
            }
            case field_4318: {
                GunItemRenderer.applyPositioningNodeTransform(model.getGroundOriginPath(), poseStack, scale.getGround());
                break;
            }
            case field_4320: 
            case field_4323: {
                GunItemRenderer.applyPositioningNodeTransform(model.getThirdPersonHandOriginPath(), poseStack, scale.getThirdPerson());
            }
        }
    }

    private void applyScaleTransform(class_811 transformType, TransformScale scale, class_4587 poseStack) {
        if (scale == null) {
            return;
        }
        Vector3f vector3f = null;
        switch (transformType) {
            case field_4319: {
                vector3f = scale.getFixed();
                break;
            }
            case field_4318: {
                vector3f = scale.getGround();
                break;
            }
            case field_4320: 
            case field_4323: {
                vector3f = scale.getThirdPerson();
            }
        }
        if (vector3f != null) {
            poseStack.method_22904(0.0, 1.5, 0.0);
            poseStack.method_22905(vector3f.x(), vector3f.y(), vector3f.z());
            poseStack.method_22904(0.0, -1.5, 0.0);
        }
    }
}

