/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.resource;

import com.google.common.collect.Maps;
import com.imguns.guns.api.client.animation.gltf.AnimationStructure;
import com.imguns.guns.client.model.BedrockAttachmentModel;
import com.imguns.guns.client.model.BedrockGunModel;
import com.imguns.guns.client.resource.pojo.PackInfo;
import com.imguns.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.imguns.guns.client.resource.pojo.display.ammo.AmmoDisplay;
import com.imguns.guns.client.resource.pojo.display.attachment.AttachmentDisplay;
import com.imguns.guns.client.resource.pojo.display.gun.GunDisplay;
import com.imguns.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.imguns.guns.client.resource.pojo.model.BedrockVersion;
import com.imguns.guns.client.resource.pojo.skin.attachment.AttachmentSkin;
import com.imguns.guns.compat.playeranimator.PlayerAnimatorCompat;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_4231;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public enum ClientAssetManager {
    INSTANCE;

    private final Map<String, PackInfo> customInfos = Maps.newHashMap();
    private final Map<class_2960, GunDisplay> gunDisplays = Maps.newHashMap();
    private final Map<class_2960, AmmoDisplay> ammoDisplays = Maps.newHashMap();
    private final Map<class_2960, AttachmentDisplay> attachmentDisplays = Maps.newHashMap();
    private final Map<class_2960, Map<class_2960, AttachmentSkin>> attachmentSkins = Maps.newHashMap();
    private final Map<class_2960, AnimationStructure> gltfAnimations = Maps.newHashMap();
    private final Map<class_2960, BedrockAnimationFile> bedrockAnimations = Maps.newHashMap();
    private final Map<class_2960, BedrockModelPOJO> models = Maps.newHashMap();
    private final Map<class_2960, class_4231> soundBuffers = Maps.newHashMap();
    private final Map<String, Map<String, String>> languages = Maps.newHashMap();
    private final Map<class_2960, BedrockAttachmentModel> tempAttachmentModelMap = Maps.newHashMap();
    private final Map<class_2960, BedrockGunModel> tempGunModelMap = Maps.newHashMap();

    @Nullable
    private static BedrockAttachmentModel getAttachmentModel(BedrockModelPOJO modelPOJO) {
        BedrockAttachmentModel attachmentModel = null;
        if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
            attachmentModel = new BedrockAttachmentModel(modelPOJO, BedrockVersion.LEGACY);
        }
        if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
            attachmentModel = new BedrockAttachmentModel(modelPOJO, BedrockVersion.NEW);
        }
        return attachmentModel;
    }

    public void putPackInfo(String namespace, PackInfo info) {
        this.customInfos.put(namespace, info);
    }

    public void putGunDisplay(class_2960 registryName, GunDisplay display) {
        this.gunDisplays.put(registryName, display);
    }

    public void putAmmoDisplay(class_2960 registryName, AmmoDisplay display) {
        this.ammoDisplays.put(registryName, display);
    }

    public void putAttachmentDisplay(class_2960 registryName, AttachmentDisplay display) {
        this.attachmentDisplays.put(registryName, display);
    }

    public void putAttachmentSkin(class_2960 registryName, AttachmentSkin skin) {
        this.attachmentSkins.compute(skin.getParent(), (name, map) -> {
            if (map == null) {
                map = Maps.newHashMap();
            }
            map.put(registryName, skin);
            return map;
        });
    }

    public void putGltfAnimation(class_2960 registryName, AnimationStructure animation) {
        this.gltfAnimations.put(registryName, animation);
    }

    public void putBedrockAnimation(class_2960 registryName, BedrockAnimationFile bedrockAnimationFile) {
        this.bedrockAnimations.put(registryName, bedrockAnimationFile);
    }

    public void putModel(class_2960 registryName, BedrockModelPOJO model) {
        this.models.put(registryName, model);
    }

    public void putSoundBuffer(class_2960 registryName, class_4231 soundBuffer) {
        this.soundBuffers.put(registryName, soundBuffer);
    }

    public void putLanguage(String region, Map<String, String> lang) {
        Map<String, String> languageMaps = this.languages.getOrDefault(region, Maps.newHashMap());
        languageMaps.putAll(lang);
        this.languages.put(region, languageMaps);
    }

    public GunDisplay getGunDisplay(class_2960 registryName) {
        return this.gunDisplays.get(registryName);
    }

    public AmmoDisplay getAmmoDisplay(class_2960 registryName) {
        return this.ammoDisplays.get(registryName);
    }

    @Nullable
    public AttachmentDisplay getAttachmentDisplay(class_2960 registryName) {
        return this.attachmentDisplays.get(registryName);
    }

    public Map<class_2960, AttachmentSkin> getAttachmentSkins(class_2960 registryName) {
        return this.attachmentSkins.get(registryName);
    }

    public AnimationStructure getGltfAnimations(class_2960 registryName) {
        return this.gltfAnimations.get(registryName);
    }

    public BedrockAnimationFile getBedrockAnimations(class_2960 registryName) {
        return this.bedrockAnimations.get(registryName);
    }

    public BedrockModelPOJO getModels(class_2960 registryName) {
        return this.models.get(registryName);
    }

    public class_4231 getSoundBuffers(class_2960 registryName) {
        return this.soundBuffers.get(registryName);
    }

    public Map<String, String> getLanguages(String region) {
        return this.languages.get(region);
    }

    @Nullable
    public PackInfo getPackInfo(class_2960 id) {
        return this.customInfos.get(id.method_12836());
    }

    @Nullable
    public BedrockAttachmentModel getOrLoadAttachmentModel(@Nullable class_2960 modelLocation) {
        if (modelLocation == null) {
            return null;
        }
        BedrockAttachmentModel model = this.tempAttachmentModelMap.get(modelLocation);
        if (model != null) {
            return model;
        }
        BedrockModelPOJO modelPOJO = this.getModels(modelLocation);
        if (modelPOJO == null) {
            return null;
        }
        BedrockAttachmentModel attachmentModel = ClientAssetManager.getAttachmentModel(modelPOJO);
        if (attachmentModel == null) {
            return null;
        }
        this.tempAttachmentModelMap.put(modelLocation, attachmentModel);
        return attachmentModel;
    }

    public void clearAll() {
        this.customInfos.clear();
        this.gunDisplays.clear();
        this.ammoDisplays.clear();
        this.attachmentDisplays.clear();
        this.attachmentSkins.clear();
        this.gltfAnimations.clear();
        this.bedrockAnimations.clear();
        this.models.clear();
        this.soundBuffers.clear();
        this.languages.clear();
        this.tempGunModelMap.clear();
        this.tempAttachmentModelMap.clear();
        PlayerAnimatorCompat.clearAllAnimationCache();
    }
}

