/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.resource;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.imguns.guns.api.resource.ResourceManager;
import com.imguns.guns.client.resource.ClientAssetManager;
import com.imguns.guns.client.resource.index.ClientAmmoIndex;
import com.imguns.guns.client.resource.index.ClientAttachmentIndex;
import com.imguns.guns.client.resource.index.ClientGunIndex;
import com.imguns.guns.client.resource.loader.asset.AmmoDisplayLoader;
import com.imguns.guns.client.resource.loader.asset.AnimationLoader;
import com.imguns.guns.client.resource.loader.asset.AttachmentDisplayLoader;
import com.imguns.guns.client.resource.loader.asset.AttachmentSkinLoader;
import com.imguns.guns.client.resource.loader.asset.BedrockModelLoader;
import com.imguns.guns.client.resource.loader.asset.GunDisplayLoader;
import com.imguns.guns.client.resource.loader.asset.LanguageLoader;
import com.imguns.guns.client.resource.loader.asset.PackInfoLoader;
import com.imguns.guns.client.resource.loader.asset.SoundLoader;
import com.imguns.guns.client.resource.loader.asset.TextureLoader;
import com.imguns.guns.client.resource.loader.index.ClientAmmoIndexLoader;
import com.imguns.guns.client.resource.loader.index.ClientAttachmentIndexLoader;
import com.imguns.guns.client.resource.loader.index.ClientGunIndexLoader;
import com.imguns.guns.client.resource.pojo.CommonTransformObject;
import com.imguns.guns.client.resource.pojo.animation.bedrock.AnimationKeyframes;
import com.imguns.guns.client.resource.pojo.animation.bedrock.SoundEffectKeyframes;
import com.imguns.guns.client.resource.pojo.model.CubesItem;
import com.imguns.guns.client.resource.serialize.AnimationKeyframesSerializer;
import com.imguns.guns.client.resource.serialize.ItemStackSerializer;
import com.imguns.guns.client.resource.serialize.SoundEffectKeyframesSerializer;
import com.imguns.guns.client.resource.serialize.Vector3fSerializer;
import com.imguns.guns.compat.playeranimator.PlayerAnimatorCompat;
import com.imguns.guns.config.common.OtherConfig;
import com.imguns.guns.resource.CommonGunPackLoader;
import com.imguns.guns.resource.network.CommonGunPackNetwork;
import com.imguns.guns.util.GetJarResources;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ClientGunPackLoader {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(CubesItem.class, (Object)new CubesItem.Deserializer()).registerTypeAdapter(Vector3f.class, (Object)new Vector3fSerializer()).registerTypeAdapter(CommonTransformObject.class, (Object)new CommonTransformObject.Serializer()).registerTypeAdapter(class_1799.class, (Object)new ItemStackSerializer()).registerTypeAdapter(AnimationKeyframes.class, (Object)new AnimationKeyframesSerializer()).registerTypeAdapter(SoundEffectKeyframes.class, (Object)new SoundEffectKeyframesSerializer()).create();
    public static final Map<class_2960, ClientGunIndex> GUN_INDEX = Maps.newHashMap();
    public static final Map<class_2960, ClientAmmoIndex> AMMO_INDEX = Maps.newHashMap();
    public static final Map<class_2960, ClientAttachmentIndex> ATTACHMENT_INDEX = Maps.newHashMap();

    public static void init() {
        ClientGunPackLoader.createFolder();
        ClientGunPackLoader.checkDefaultPack();
        CommonGunPackNetwork.clear();
    }

    public static void reloadAsset() {
        ClientAssetManager.INSTANCE.clearAll();
        File[] files = CommonGunPackLoader.FOLDER.toFile().listFiles((dir, name) -> true);
        if (files != null) {
            ClientGunPackLoader.readAsset(files);
        }
    }

    public static void reloadIndex() {
        AMMO_INDEX.clear();
        GUN_INDEX.clear();
        ATTACHMENT_INDEX.clear();
        ClientAmmoIndexLoader.loadAmmoIndex();
        ClientGunIndexLoader.loadGunIndex();
        ClientAttachmentIndexLoader.loadAttachmentIndex();
    }

    private static void createFolder() {
        File folder = CommonGunPackLoader.FOLDER.toFile();
        if (!folder.isDirectory()) {
            try {
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void checkDefaultPack() {
        if (!((Boolean)OtherConfig.DEFAULT_PACK_DEBUG.get()).booleanValue()) {
            for (ResourceManager.ExtraEntry entry : ResourceManager.EXTRA_ENTRIES) {
                GetJarResources.copyModDirectory(entry.modMainClass(), entry.srcPath(), CommonGunPackLoader.FOLDER, entry.extraDirName());
            }
        }
    }

    private static void readAsset(File[] files) {
        for (File file : files) {
            if (file.isFile() && file.getName().endsWith(".zip")) {
                ClientGunPackLoader.readZipAsset(file);
            }
            if (!file.isDirectory()) continue;
            File[] subFiles = file.listFiles((dir, name) -> true);
            if (subFiles == null) {
                return;
            }
            for (File namespaceFile : subFiles) {
                ClientGunPackLoader.readDirAsset(namespaceFile);
            }
        }
    }

    private static void readDirAsset(File root) {
        if (root.isDirectory()) {
            GunDisplayLoader.load(root);
            AmmoDisplayLoader.load(root);
            AttachmentDisplayLoader.load(root);
            AttachmentSkinLoader.load(root);
            AnimationLoader.load(root);
            PlayerAnimatorCompat.loadAnimationFromFile(root);
            BedrockModelLoader.load(root);
            TextureLoader.load(root);
            SoundLoader.load(root);
            LanguageLoader.load(root);
            PackInfoLoader.load(root);
        }
    }

    public static void readZipAsset(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> iteration = zipFile.entries();
            while (iteration.hasMoreElements()) {
                String path = iteration.nextElement().getName();
                if (GunDisplayLoader.load(zipFile, path) || AmmoDisplayLoader.load(zipFile, path) || AttachmentDisplayLoader.load(zipFile, path) || AttachmentSkinLoader.load(zipFile, path) || AnimationLoader.load(zipFile, path) || PlayerAnimatorCompat.loadAnimationFromZip(zipFile, path) || BedrockModelLoader.load(zipFile, path) || TextureLoader.load(zipFile, path) || SoundLoader.load(zipFile, path) || LanguageLoader.load(zipFile, path)) continue;
                PackInfoLoader.load(zipFile, path);
            }
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    public static Set<Map.Entry<class_2960, ClientGunIndex>> getAllGuns() {
        return GUN_INDEX.entrySet();
    }

    public static Set<Map.Entry<class_2960, ClientAmmoIndex>> getAllAmmo() {
        return AMMO_INDEX.entrySet();
    }

    public static Set<Map.Entry<class_2960, ClientAttachmentIndex>> getAllAttachments() {
        return ATTACHMENT_INDEX.entrySet();
    }

    public static Optional<ClientGunIndex> getGunIndex(class_2960 registryName) {
        return Optional.ofNullable(GUN_INDEX.get(registryName));
    }

    public static Optional<ClientAmmoIndex> getAmmoIndex(class_2960 registryName) {
        return Optional.ofNullable(AMMO_INDEX.get(registryName));
    }

    public static Optional<ClientAttachmentIndex> getAttachmentIndex(class_2960 registryName) {
        return Optional.ofNullable(ATTACHMENT_INDEX.get(registryName));
    }
}

