/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.resource.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.imguns.guns.client.model.BedrockAttachmentModel;
import com.imguns.guns.client.resource.ClientAssetManager;
import com.imguns.guns.client.resource.index.ClientAttachmentSkinIndex;
import com.imguns.guns.client.resource.pojo.display.attachment.AttachmentDisplay;
import com.imguns.guns.client.resource.pojo.display.attachment.AttachmentLod;
import com.imguns.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.imguns.guns.client.resource.pojo.model.BedrockVersion;
import com.imguns.guns.client.resource.pojo.skin.attachment.AttachmentSkin;
import com.imguns.guns.resource.CommonAssetManager;
import com.imguns.guns.resource.pojo.AttachmentIndexPOJO;
import com.imguns.guns.resource.pojo.data.attachment.AttachmentData;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1047;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientAttachmentIndex {
    private final Map<class_2960, ClientAttachmentSkinIndex> skinIndexMap = Maps.newHashMap();
    private String name;
    @Nullable
    private BedrockAttachmentModel attachmentModel;
    @Nullable
    private class_2960 modelTexture;
    @Nullable
    private Pair<BedrockAttachmentModel, class_2960> lodModel;
    private class_2960 slotTexture;
    private AttachmentData data;
    private float fov = 70.0f;
    private float @Nullable [] zoom;
    private boolean isScope;
    private boolean isSight;
    private boolean showMuzzle;
    @Nullable
    private String adapterNodeName;
    @Nullable
    private String tooltipKey;
    private Map<String, class_2960> sounds;

    private ClientAttachmentIndex() {
    }

    public static ClientAttachmentIndex getInstance(class_2960 registryName, AttachmentIndexPOJO indexPOJO) throws IllegalArgumentException {
        ClientAttachmentIndex index = new ClientAttachmentIndex();
        ClientAttachmentIndex.checkIndex(indexPOJO, index);
        AttachmentDisplay display = ClientAttachmentIndex.checkDisplay(indexPOJO, index);
        ClientAttachmentIndex.checkData(indexPOJO, index);
        ClientAttachmentIndex.checkName(indexPOJO, index);
        ClientAttachmentIndex.checkSlotTexture(display, index);
        ClientAttachmentIndex.checkTextureAndModel(display, index);
        ClientAttachmentIndex.checkLod(display, index);
        ClientAttachmentIndex.checkSkins(registryName, index);
        ClientAttachmentIndex.checkSounds(display, index);
        return index;
    }

    private static void checkIndex(AttachmentIndexPOJO attachmentIndexPOJO, ClientAttachmentIndex index) {
        Preconditions.checkArgument((attachmentIndexPOJO != null ? 1 : 0) != 0, (Object)"index object file is empty");
        index.tooltipKey = attachmentIndexPOJO.getTooltip();
    }

    @NotNull
    private static AttachmentDisplay checkDisplay(AttachmentIndexPOJO indexPOJO, ClientAttachmentIndex index) {
        class_2960 pojoDisplay = indexPOJO.getDisplay();
        Preconditions.checkArgument((pojoDisplay != null ? 1 : 0) != 0, (Object)"index object missing display field");
        AttachmentDisplay display = ClientAssetManager.INSTANCE.getAttachmentDisplay(pojoDisplay);
        Preconditions.checkArgument((display != null ? 1 : 0) != 0, (Object)"there is no corresponding display file");
        Preconditions.checkArgument((display.getFov() > 0.0f ? 1 : 0) != 0, (Object)"fov must > 0");
        index.fov = display.getFov();
        index.zoom = display.getZoom();
        if (index.zoom != null) {
            for (int i = 0; i < index.zoom.length; ++i) {
                if (!(index.zoom[i] < 1.0f)) continue;
                throw new IllegalArgumentException("zoom must >= 1");
            }
        }
        index.isScope = display.isScope();
        index.isSight = display.isSight();
        index.adapterNodeName = display.getAdapterNodeName();
        index.showMuzzle = display.isShowMuzzle();
        return display;
    }

    private static void checkData(AttachmentIndexPOJO indexPOJO, ClientAttachmentIndex index) {
        class_2960 dataId = indexPOJO.getData();
        Preconditions.checkArgument((dataId != null ? 1 : 0) != 0, (Object)"index object missing pojoData field");
        AttachmentData data = CommonAssetManager.INSTANCE.getAttachmentData(dataId);
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"there is no corresponding data file");
        index.data = data;
    }

    private static void checkName(AttachmentIndexPOJO indexPOJO, ClientAttachmentIndex index) {
        index.name = indexPOJO.getName();
        if (StringUtils.isBlank((CharSequence)index.name)) {
            index.name = "custom.immersive_guns.error.no_name";
        }
    }

    private static void checkSlotTexture(AttachmentDisplay display, ClientAttachmentIndex index) {
        index.slotTexture = Objects.requireNonNullElseGet(display.getSlotTextureLocation(), class_1047::method_4539);
    }

    private static void checkTextureAndModel(AttachmentDisplay display, ClientAttachmentIndex index) {
        index.attachmentModel = ClientAssetManager.INSTANCE.getOrLoadAttachmentModel(display.getModel());
        if (index.attachmentModel != null) {
            index.attachmentModel.setIsScope(display.isScope());
            index.attachmentModel.setIsSight(display.isSight());
        }
        index.modelTexture = display.getTexture();
    }

    private static void checkLod(AttachmentDisplay display, ClientAttachmentIndex index) {
        AttachmentLod gunLod = display.getAttachmentLod();
        if (gunLod != null) {
            BedrockAttachmentModel model;
            class_2960 texture = gunLod.getModelTexture();
            if (gunLod.getModelLocation() == null) {
                return;
            }
            if (texture == null) {
                return;
            }
            BedrockModelPOJO modelPOJO = ClientAssetManager.INSTANCE.getModels(gunLod.getModelLocation());
            if (modelPOJO == null) {
                return;
            }
            if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
                model = new BedrockAttachmentModel(modelPOJO, BedrockVersion.LEGACY);
                index.lodModel = Pair.of((Object)model, (Object)texture);
            }
            if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
                model = new BedrockAttachmentModel(modelPOJO, BedrockVersion.NEW);
                index.lodModel = Pair.of((Object)model, (Object)texture);
            }
        }
    }

    private static void checkSkins(class_2960 registryName, ClientAttachmentIndex index) {
        Map<class_2960, AttachmentSkin> skins = ClientAssetManager.INSTANCE.getAttachmentSkins(registryName);
        if (skins != null) {
            for (Map.Entry<class_2960, AttachmentSkin> entry : skins.entrySet()) {
                ClientAttachmentSkinIndex skinIndex = ClientAttachmentSkinIndex.getInstance(entry.getValue());
                index.skinIndexMap.put(entry.getKey(), skinIndex);
            }
        }
    }

    private static void checkSounds(AttachmentDisplay display, ClientAttachmentIndex index) {
        Map<String, class_2960> displaySounds = display.getSounds();
        if (displaySounds == null) {
            index.sounds = Maps.newHashMap();
            return;
        }
        index.sounds = displaySounds;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getTooltipKey() {
        return this.tooltipKey;
    }

    @Nullable
    public BedrockAttachmentModel getAttachmentModel() {
        return this.attachmentModel;
    }

    @Nullable
    public class_2960 getModelTexture() {
        return this.modelTexture;
    }

    @Nullable
    public Pair<BedrockAttachmentModel, class_2960> getLodModel() {
        return this.lodModel;
    }

    public class_2960 getSlotTexture() {
        return this.slotTexture;
    }

    public float getFov() {
        return this.fov;
    }

    public float @Nullable [] getZoom() {
        return this.zoom;
    }

    public AttachmentData getData() {
        return this.data;
    }

    @Nullable
    public ClientAttachmentSkinIndex getSkinIndex(@Nullable class_2960 skinName) {
        if (skinName == null) {
            return null;
        }
        return this.skinIndexMap.get(skinName);
    }

    public boolean isScope() {
        return this.isScope;
    }

    public boolean isSight() {
        return this.isSight;
    }

    @Nullable
    public String getAdapterNodeName() {
        return this.adapterNodeName;
    }

    public boolean isShowMuzzle() {
        return this.showMuzzle;
    }

    public Map<String, class_2960> getSounds() {
        return this.sounds;
    }
}

