/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.resource.loader.asset;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.imguns.guns.GunMod;
import com.imguns.guns.client.resource.ClientAssetManager;
import com.imguns.guns.client.resource.ClientGunPackLoader;
import com.imguns.guns.client.resource.pojo.skin.attachment.AttachmentSkin;
import com.imguns.guns.util.IOReader;
import com.imguns.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class AttachmentSkinLoader {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"AttachmentSkinLoader");
    private static final Pattern SKIN_PATTERN = Pattern.compile("^(\\w+)/attachments/skin/([\\w/]+)\\.json$");

    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = SKIN_PATTERN.matcher(zipPath);
        if (matcher.find()) {
            boolean bl;
            block10: {
                String namespace = TacPathVisitor.checkNamespace(matcher.group(1));
                String path = matcher.group(2);
                ZipEntry entry = zipFile.getEntry(zipPath);
                if (entry == null) {
                    GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                    return false;
                }
                InputStream stream = zipFile.getInputStream(entry);
                try {
                    class_2960 registryName = new class_2960(namespace, path);
                    AttachmentSkin display = (AttachmentSkin)ClientGunPackLoader.GSON.fromJson(IOReader.toString(stream, StandardCharsets.UTF_8), AttachmentSkin.class);
                    ClientAssetManager.INSTANCE.putAttachmentSkin(registryName, display);
                    bl = true;
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException exception) {
                        GunMod.LOGGER.warn(MARKER, "Failed to read skin display file: {}, entry: {}", (Object)zipFile, (Object)entry);
                        exception.printStackTrace();
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    public static void load(File root) {
        Path displayPath = root.toPath().resolve("attachments/skin");
        if (Files.isDirectory(displayPath, new LinkOption[0])) {
            TacPathVisitor visitor = new TacPathVisitor(displayPath.toFile(), root.getName(), ".json", (id, file) -> {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                    AttachmentSkin display = (AttachmentSkin)ClientGunPackLoader.GSON.fromJson(IOReader.toString(stream, StandardCharsets.UTF_8), AttachmentSkin.class);
                    ClientAssetManager.INSTANCE.putAttachmentSkin((class_2960)id, display);
                }
                catch (JsonIOException | JsonSyntaxException | IOException exception) {
                    GunMod.LOGGER.warn(MARKER, "Failed to read skin display file: {}", file);
                    exception.printStackTrace();
                }
            });
            try {
                Files.walkFileTree(displayPath, visitor);
            }
            catch (IOException e) {
                GunMod.LOGGER.warn(MARKER, "Failed to walk file tree: {}", (Object)displayPath);
                e.printStackTrace();
            }
        }
    }
}

