/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.resource.loader.asset;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.imguns.guns.GunMod;
import com.imguns.guns.client.resource.ClientAssetManager;
import com.imguns.guns.client.resource.ClientGunPackLoader;
import com.imguns.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.imguns.guns.util.IOReader;
import com.imguns.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class BedrockModelLoader {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"BedrockModelLoader");
    private static final Pattern MODEL_PATTERN = Pattern.compile("^(\\w+)/models/([\\w/]+)\\.json$");

    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = MODEL_PATTERN.matcher(zipPath);
        if (matcher.find()) {
            boolean bl;
            block10: {
                String namespace = TacPathVisitor.checkNamespace(matcher.group(1));
                String path = matcher.group(2);
                ZipEntry entry = zipFile.getEntry(zipPath);
                if (entry == null) {
                    GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                    return false;
                }
                InputStream modelFileStream = zipFile.getInputStream(entry);
                try {
                    class_2960 registryName = new class_2960(namespace, path);
                    BedrockModelPOJO modelPOJO = (BedrockModelPOJO)ClientGunPackLoader.GSON.fromJson(IOReader.toString(modelFileStream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
                    ClientAssetManager.INSTANCE.putModel(registryName, modelPOJO);
                    bl = true;
                    if (modelFileStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (modelFileStream != null) {
                            try {
                                modelFileStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException exception) {
                        GunMod.LOGGER.warn(MARKER, "Failed to read model file: {}, entry: {}", (Object)zipFile, (Object)entry);
                        exception.printStackTrace();
                    }
                }
                modelFileStream.close();
            }
            return bl;
        }
        return false;
    }

    public static void load(File root) {
        Path modelPath = root.toPath().resolve("models");
        if (Files.isDirectory(modelPath, new LinkOption[0])) {
            TacPathVisitor visitor = new TacPathVisitor(modelPath.toFile(), root.getName(), ".json", (id, file) -> {
                try (InputStream modelFileStream = Files.newInputStream(file, new OpenOption[0]);){
                    BedrockModelPOJO modelPOJO = (BedrockModelPOJO)ClientGunPackLoader.GSON.fromJson(IOReader.toString(modelFileStream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
                    ClientAssetManager.INSTANCE.putModel((class_2960)id, modelPOJO);
                }
                catch (JsonIOException | JsonSyntaxException | IOException exception) {
                    GunMod.LOGGER.warn(MARKER, "Failed to read model file: {}", file);
                    exception.printStackTrace();
                }
            });
            try {
                Files.walkFileTree(modelPath, visitor);
            }
            catch (IOException e) {
                GunMod.LOGGER.warn(MARKER, "Failed to walk file tree: {}", (Object)modelPath);
                e.printStackTrace();
            }
        }
    }
}

