/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.resource.loader.asset;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.imguns.guns.GunMod;
import com.imguns.guns.client.resource.ClientAssetManager;
import com.imguns.guns.client.resource.ClientGunPackLoader;
import com.imguns.guns.client.resource.pojo.PackInfo;
import com.imguns.guns.util.IOReader;
import com.imguns.guns.util.TacPathVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class PackInfoLoader {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"CreativeTabLoader");
    private static final Pattern PACK_INFO_PATTERN = Pattern.compile("^(\\w+)/pack\\.json$");

    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = PACK_INFO_PATTERN.matcher(zipPath);
        if (matcher.find()) {
            boolean bl;
            block10: {
                String namespace = TacPathVisitor.checkNamespace(matcher.group(1));
                ZipEntry entry = zipFile.getEntry(zipPath);
                if (entry == null) {
                    GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                    return false;
                }
                InputStream inputStream = zipFile.getInputStream(entry);
                try {
                    PackInfo packInfo = (PackInfo)ClientGunPackLoader.GSON.fromJson(IOReader.toString(inputStream, StandardCharsets.UTF_8), PackInfo.class);
                    ClientAssetManager.INSTANCE.putPackInfo(namespace, packInfo);
                    bl = true;
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException exception) {
                        GunMod.LOGGER.warn(MARKER, "Failed to read info json: {}, entry: {}", (Object)zipFile, (Object)entry);
                        exception.printStackTrace();
                    }
                }
                inputStream.close();
            }
            return bl;
        }
        return false;
    }

    public static void load(File root) {
        Path packInfoFilePath = root.toPath().resolve("pack.json");
        if (Files.isRegularFile(packInfoFilePath, new LinkOption[0])) {
            try (InputStream stream = Files.newInputStream(packInfoFilePath, new OpenOption[0]);){
                PackInfo packInfo = (PackInfo)ClientGunPackLoader.GSON.fromJson(IOReader.toString(stream, StandardCharsets.UTF_8), PackInfo.class);
                ClientAssetManager.INSTANCE.putPackInfo(root.getName(), packInfo);
            }
            catch (JsonIOException | JsonSyntaxException | IOException exception) {
                GunMod.LOGGER.warn(MARKER, "Failed to read info json: {}", (Object)packInfoFilePath);
                exception.printStackTrace();
            }
        }
    }
}

