/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.resource.loader.asset;

import com.imguns.guns.GunMod;
import com.imguns.guns.client.resource.texture.FilePackTexture;
import com.imguns.guns.client.resource.texture.ZipPackTexture;
import com.imguns.guns.util.TacPathVisitor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class TextureLoader {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"TextureLoader");
    private static final Pattern TEXTURE_PATTERN = Pattern.compile("^(\\w+)/textures/([\\w/]+)\\.png$");

    public static boolean load(ZipFile zipFile, String zipPath) {
        Matcher matcher = TEXTURE_PATTERN.matcher(zipPath);
        if (matcher.find()) {
            String ori_namespace = matcher.group(1);
            String namespace = TacPathVisitor.checkNamespace(ori_namespace);
            String path = matcher.group(2);
            ZipEntry entry = zipFile.getEntry(zipPath);
            if (entry == null) {
                GunMod.LOGGER.warn(MARKER, "{} file don't exist", (Object)zipPath);
                return false;
            }
            class_2960 ori_id = new class_2960(ori_namespace, path);
            class_2960 id = new class_2960(namespace, path);
            ZipPackTexture zipPackTexture = new ZipPackTexture(ori_id, zipFile.getName());
            class_310.method_1551().method_1531().method_4616(id, (class_1044)zipPackTexture);
            return true;
        }
        return false;
    }

    public static void load(File root) {
        Path filePath = root.toPath().resolve("textures");
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            TacPathVisitor visitor = new TacPathVisitor(filePath.toFile(), root.getName(), ".png", (id, file) -> {
                FilePackTexture filePackTexture = new FilePackTexture((class_2960)id, (Path)file);
                class_310.method_1551().method_1531().method_4616(id, (class_1044)filePackTexture);
            });
            try {
                Files.walkFileTree(filePath, visitor);
            }
            catch (Exception e) {
                GunMod.LOGGER.warn(MARKER, "Failed to walk file tree: {}", (Object)filePath);
                e.printStackTrace();
            }
        }
    }
}

