/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.resource.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

public class ZipPackTexture
extends class_1044 {
    private final class_2960 registerId;
    private final Path zipFilePath;

    public ZipPackTexture(class_2960 registerId, String zipFilePath) {
        this.registerId = registerId;
        this.zipFilePath = Paths.get(zipFilePath, new String[0]);
    }

    public void method_4625(@NotNull class_3300 manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        try (ZipFile zipFile = new ZipFile(this.zipFilePath.toFile());){
            ZipEntry entry = zipFile.getEntry(String.format("%s/textures/%s.png", this.registerId.method_12836(), this.registerId.method_12832()));
            if (entry == null) {
                return;
            }
            try (InputStream stream = zipFile.getInputStream(entry);){
                class_1011 imageIn = class_1011.method_4309((InputStream)stream);
                int width = imageIn.method_4307();
                int height = imageIn.method_4323();
                TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)width, (int)height);
                imageIn.method_22619(0, 0, 0, 0, 0, width, height, false, false, false, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class_2960 getRegisterId() {
        return this.registerId;
    }
}

