/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.client.tooltip;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.attachment.AttachmentType;
import com.imguns.guns.api.item.builder.AttachmentItemBuilder;
import com.imguns.guns.api.item.builder.GunItemBuilder;
import com.imguns.guns.client.resource.ClientAssetManager;
import com.imguns.guns.client.resource.pojo.PackInfo;
import com.imguns.guns.inventory.tooltip.AttachmentItemTooltip;
import com.imguns.guns.resource.pojo.data.attachment.AttachmentData;
import com.imguns.guns.resource.pojo.data.attachment.RecoilModifier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ClientAttachmentItemTooltip
implements class_5684 {
    private static final Cache<class_2960, List<class_1799>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build();
    private final class_2960 attachmentId;
    private final List<class_2561> components = Lists.newArrayList();
    private final class_5250 tips = class_2561.method_43471((String)"tooltip.immersive_guns.attachment.yaw.shift");
    private final class_5250 support = class_2561.method_43471((String)"tooltip.immersive_guns.attachment.yaw.support");
    @Nullable
    private class_5250 packInfo;
    private List<class_1799> showGuns = Lists.newArrayList();

    public ClientAttachmentItemTooltip(AttachmentItemTooltip tooltip) {
        this.attachmentId = tooltip.attachmentId();
        this.addText(tooltip.type());
        this.getShowGuns();
        this.addPackInfo();
    }

    private void addPackInfo() {
        PackInfo packInfoObject = ClientAssetManager.INSTANCE.getPackInfo(this.attachmentId);
        if (packInfoObject != null) {
            this.packInfo = class_2561.method_43471((String)packInfoObject.getName()).method_27692(class_124.field_1078).method_27692(class_124.field_1056);
        }
    }

    private static List<class_1799> getAllAllowGuns(List<class_1799> output, class_2960 attachmentId) {
        class_1799 attachment = AttachmentItemBuilder.create().setId(attachmentId).build();
        TimelessAPI.getAllCommonGunIndex().forEach(entry -> {
            class_2960 gunId = (class_2960)entry.getKey();
            class_1799 gun = GunItemBuilder.create().setId(gunId).build();
            class_1792 patt0$temp = gun.method_7909();
            if (!(patt0$temp instanceof IGun)) {
                return;
            }
            IGun iGun = (IGun)patt0$temp;
            if (iGun.allowAttachment(gun, attachment)) {
                output.add(gun);
            }
        });
        return output;
    }

    public int method_32661() {
        if (!class_437.method_25442()) {
            return this.components.size() * 10 + 28;
        }
        return (this.showGuns.size() - 1) / 16 * 18 + 50 + this.components.size() * 10;
    }

    public int method_32664(class_327 font) {
        int[] width = new int[]{0};
        if (this.packInfo != null) {
            width[0] = Math.max(width[0], font.method_27525((class_5348)this.packInfo) + 4);
        }
        this.components.forEach(c -> {
            width[0] = Math.max(width[0], font.method_27525((class_5348)c));
        });
        if (!class_437.method_25442()) {
            return Math.max(width[0], font.method_27525((class_5348)this.tips) + 4);
        }
        width[0] = Math.max(width[0], font.method_27525((class_5348)this.support) + 4);
        if (this.showGuns.size() > 15) {
            return Math.max(width[0], 260);
        }
        return Math.max(width[0], this.showGuns.size() * 16 + 4);
    }

    public void method_32665(class_327 font, int pX, int pY, Matrix4f matrix4f, class_4597.class_4598 bufferSource) {
        int yOffset = pY;
        for (class_2561 component : this.components) {
            font.method_30882(component, (float)pX, (float)yOffset, 0xFFAA00, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        }
        if (!class_437.method_25442()) {
            font.method_30882((class_2561)this.tips, (float)pX, (float)(pY + 5 + this.components.size() * 10), 0x9E9E9E, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        } else {
            yOffset += (this.showGuns.size() - 1) / 16 * 18 + 32;
        }
        if (this.packInfo != null) {
            font.method_30882((class_2561)this.packInfo, (float)pX, (float)(yOffset + 8), 0xFFFFFF, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }

    public void method_32666(class_327 font, int mouseX, int mouseY, class_332 gui) {
        if (!class_437.method_25442()) {
            return;
        }
        int minY = this.components.size() * 10 + 3;
        int maxX = this.method_32664(font);
        gui.method_25294(mouseX, mouseY + minY, mouseX + maxX, mouseY + minY + 11, -1895780097);
        gui.method_27535(font, (class_2561)this.support, mouseX + 2, mouseY + minY + 2, 14938877);
        for (int i = 0; i < this.showGuns.size(); ++i) {
            class_1799 stack = this.showGuns.get(i);
            int x = i % 16 * 16 + 2;
            int y = i / 16 * 18 + minY + 15;
            gui.method_51427(stack, mouseX + x, mouseY + y);
        }
    }

    private void getShowGuns() {
        try {
            this.showGuns = (List)CACHE.get((Object)this.attachmentId, () -> ClientAttachmentItemTooltip.getAllAllowGuns(Lists.newArrayList(), this.attachmentId));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void addText(AttachmentType type) {
        TimelessAPI.getClientAttachmentIndex(this.attachmentId).ifPresent(index -> {
            float adsAddendTime;
            float[] zoom;
            AttachmentData data = index.getData();
            @Nullable String tooltipKey = index.getTooltipKey();
            if (tooltipKey != null) {
                String text = class_1074.method_4662((String)tooltipKey, (Object[])new Object[0]);
                String[] split = text.split("\n");
                Arrays.stream(split).forEach(s -> this.components.add((class_2561)class_2561.method_43470((String)s).method_27692(class_124.field_1080)));
            }
            if (type == AttachmentType.SCOPE && (zoom = index.getZoom()) != null) {
                Object[] zoomText = new String[zoom.length];
                for (int i = 0; i < zoom.length; ++i) {
                    zoomText[i] = "x" + zoom[i];
                }
                String zoomJoinText = StringUtils.join((Object[])zoomText, (String)", ");
                this.components.add((class_2561)class_2561.method_43469((String)"tooltip.immersive_guns.attachment.zoom", (Object[])new Object[]{zoomJoinText}).method_27692(class_124.field_1065));
            }
            if (type == AttachmentType.EXTENDED_MAG) {
                int magLevel = data.getExtendedMagLevel();
                if (magLevel == 1) {
                    this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.extended_mag_level_1").method_27692(class_124.field_1080));
                } else if (magLevel == 2) {
                    this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.extended_mag_level_2").method_27692(class_124.field_1078));
                } else if (magLevel == 3) {
                    this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.extended_mag_level_3").method_27692(class_124.field_1076));
                }
            }
            if ((adsAddendTime = data.getAdsAddendTime()) > 0.0f) {
                this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.ads.increase").method_27692(class_124.field_1061));
            } else if (adsAddendTime < 0.0f) {
                this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.ads.decrease").method_27692(class_124.field_1060));
            }
            float inaccuracyAddend = data.getInaccuracyAddend();
            if (inaccuracyAddend > 0.0f) {
                this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.inaccuracy.increase").method_27692(class_124.field_1061));
            } else if (inaccuracyAddend < 0.0f) {
                this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.inaccuracy.decrease").method_27692(class_124.field_1060));
            }
            RecoilModifier recoilModifier = data.getRecoilModifier();
            if (recoilModifier != null) {
                float pitch = recoilModifier.getPitch();
                if (pitch > 0.0f) {
                    this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.pitch.increase").method_27692(class_124.field_1061));
                } else if (pitch < 0.0f) {
                    this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.pitch.decrease").method_27692(class_124.field_1060));
                }
                float yaw = recoilModifier.getYaw();
                if (yaw > 0.0f) {
                    this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.yaw.increase").method_27692(class_124.field_1061));
                } else if (yaw < 0.0f) {
                    this.components.add((class_2561)class_2561.method_43471((String)"tooltip.immersive_guns.attachment.yaw.decrease").method_27692(class_124.field_1060));
                }
            }
        });
    }
}

