/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.compat.jei.entry;

import com.google.common.collect.Lists;
import com.imguns.guns.api.TimelessAPI;
import com.imguns.guns.api.item.GunTabType;
import com.imguns.guns.api.item.IGun;
import com.imguns.guns.api.item.builder.AttachmentItemBuilder;
import com.imguns.guns.api.item.builder.GunItemBuilder;
import com.imguns.guns.resource.index.CommonGunIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class AttachmentQueryEntry {
    private final class_1799 attachmentStack;
    private List<class_1799> allowGunStacks;
    private List<class_1799> extraAllowGunStacks;

    public AttachmentQueryEntry(class_2960 attachmentId, GunTabType type) {
        this.attachmentStack = AttachmentItemBuilder.create().setId(attachmentId).build();
        this.allowGunStacks = Lists.newArrayList();
        this.extraAllowGunStacks = Lists.newArrayList();
        this.addAllAllowGuns(type);
        this.dividedGuns();
    }

    public static List<AttachmentQueryEntry> getAllAttachmentQueryEntries() {
        ArrayList entries = Lists.newArrayList();
        TimelessAPI.getAllCommonAttachmentIndex().forEach(entry -> {
            for (GunTabType tabType : GunTabType.values()) {
                AttachmentQueryEntry queryEntry = new AttachmentQueryEntry((class_2960)entry.getKey(), tabType);
                if (queryEntry.getAllowGunStacks().isEmpty()) continue;
                entries.add(queryEntry);
            }
        });
        return entries;
    }

    public class_1799 getAttachmentStack() {
        return this.attachmentStack;
    }

    public List<class_1799> getAllowGunStacks() {
        return this.allowGunStacks;
    }

    public List<class_1799> getExtraAllowGunStacks() {
        return this.extraAllowGunStacks;
    }

    private void addAllAllowGuns(GunTabType type) {
        TimelessAPI.getAllCommonGunIndex().forEach(entry -> {
            String gunType;
            String tabType = type.name().toLowerCase(Locale.US);
            if (tabType.equals(gunType = ((CommonGunIndex)entry.getValue()).getType())) {
                class_1799 gun = GunItemBuilder.create().setId((class_2960)entry.getKey()).build();
                class_1792 patt0$temp = gun.method_7909();
                if (!(patt0$temp instanceof IGun)) {
                    return;
                }
                IGun iGun = (IGun)patt0$temp;
                if (iGun.allowAttachment(gun, this.attachmentStack)) {
                    this.allowGunStacks.add(gun);
                }
            }
        });
    }

    private void dividedGuns() {
        int size = this.allowGunStacks.size();
        if (size >= 60) {
            this.extraAllowGunStacks = this.allowGunStacks.subList(60, size);
            this.allowGunStacks = this.allowGunStacks.subList(0, 60);
        }
    }
}

