/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.compat.playeranimator;

import com.imguns.guns.api.event.common.GunDrawEvent;
import com.imguns.guns.api.event.common.GunMeleeEvent;
import com.imguns.guns.api.event.common.GunReloadEvent;
import com.imguns.guns.api.event.common.GunShootEvent;
import com.imguns.guns.client.resource.index.ClientGunIndex;
import com.imguns.guns.compat.playeranimator.animation.AnimationDataRegisterFactory;
import com.imguns.guns.compat.playeranimator.animation.AnimationManager;
import com.imguns.guns.compat.playeranimator.animation.PlayerAnimatorAssetManager;
import com.imguns.guns.compat.playeranimator.animation.PlayerAnimatorLoader;
import java.io.File;
import java.util.zip.ZipFile;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_742;

public class PlayerAnimatorCompat {
    public static class_2960 LOWER_ANIMATION = new class_2960("immersive_guns", "lower_animation");
    public static class_2960 LOOP_UPPER_ANIMATION = new class_2960("immersive_guns", "loop_upper_animation");
    public static class_2960 ONCE_UPPER_ANIMATION = new class_2960("immersive_guns", "once_upper_animation");
    public static class_2960 ROTATION_ANIMATION = new class_2960("immersive_guns", "rotation");
    private static final String MOD_ID = "player-animator";
    private static boolean INSTALLED = false;

    public static void init() {
        INSTALLED = FabricLoader.getInstance().isModLoaded(MOD_ID);
        if (PlayerAnimatorCompat.isInstalled()) {
            AnimationDataRegisterFactory.registerData();
            AnimationManager manager = new AnimationManager();
            GunShootEvent.EVENT.register(manager::onFire);
            GunReloadEvent.EVENT.register(manager::onReload);
            GunMeleeEvent.EVENT.register(manager::onMelee);
            GunDrawEvent.EVENT.register(manager::onDraw);
        }
    }

    public static boolean loadAnimationFromZip(ZipFile zipFile, String zipPath) {
        if (PlayerAnimatorCompat.isInstalled()) {
            return PlayerAnimatorLoader.load(zipFile, zipPath);
        }
        return false;
    }

    public static void loadAnimationFromFile(File file) {
        if (PlayerAnimatorCompat.isInstalled()) {
            PlayerAnimatorLoader.load(file);
        }
    }

    public static void clearAllAnimationCache() {
        if (PlayerAnimatorCompat.isInstalled()) {
            PlayerAnimatorAssetManager.INSTANCE.clearAll();
        }
    }

    public static boolean hasPlayerAnimator3rd(class_1309 livingEntity, ClientGunIndex gunIndex) {
        if (PlayerAnimatorCompat.isInstalled() && livingEntity instanceof class_742) {
            return AnimationManager.hasPlayerAnimator3rd(gunIndex);
        }
        return false;
    }

    public static void stopAllAnimation(class_1309 livingEntity) {
        if (PlayerAnimatorCompat.isInstalled() && livingEntity instanceof class_742) {
            class_742 player = (class_742)livingEntity;
            AnimationManager.stopAllAnimation(player);
        }
    }

    public static void playAnimation(class_1309 livingEntity, ClientGunIndex gunIndex, float limbSwingAmount) {
        if (PlayerAnimatorCompat.isInstalled() && livingEntity instanceof class_742) {
            class_742 player = (class_742)livingEntity;
            AnimationManager.playLowerAnimation(player, gunIndex, limbSwingAmount);
            AnimationManager.playLoopUpperAnimation(player, gunIndex, limbSwingAmount);
            AnimationManager.playRotationAnimation(player, gunIndex);
        }
    }

    public static boolean isInstalled() {
        return INSTALLED;
    }
}

