/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.config.util;

import com.google.common.collect.Maps;
import com.imguns.guns.config.sync.SyncConfig;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_238;
import net.minecraft.class_2960;

public class HeadShotAABBConfigRead {
    private static final Map<class_2960, class_238> AABB_CHECK = Maps.newHashMap();
    private static final Pattern REG = Pattern.compile("^([a-z0-9_.-]+:[a-z0-9/._-]+) *?\\[([-+]?[0-9]*\\.?[0-9]+), *?([-+]?[0-9]*\\.?[0-9]+), *?([-+]?[0-9]*\\.?[0-9]+), *?([-+]?[0-9]*\\.?[0-9]+), *?([-+]?[0-9]*\\.?[0-9]+), *?([-+]?[0-9]*\\.?[0-9]+),*? *?]");

    public static void init() {
        AABB_CHECK.clear();
        List configData = (List)SyncConfig.HEAD_SHOT_AABB.get();
        for (String text : configData) {
            HeadShotAABBConfigRead.addCheck(text);
        }
    }

    public static void addCheck(String text) {
        Matcher matcher = REG.matcher(text);
        if (matcher.find()) {
            class_2960 id = new class_2960(matcher.group(1));
            double x1 = Double.parseDouble(matcher.group(2));
            double y1 = Double.parseDouble(matcher.group(3));
            double z1 = Double.parseDouble(matcher.group(4));
            double x2 = Double.parseDouble(matcher.group(5));
            double y2 = Double.parseDouble(matcher.group(6));
            double z2 = Double.parseDouble(matcher.group(7));
            class_238 aabb = new class_238(x1, y1, z1, x2, y2, z2);
            AABB_CHECK.put(id, aabb);
        }
    }

    public static void clearAABB() {
        AABB_CHECK.clear();
    }

    public static class_238 getAABB(class_2960 id) {
        return AABB_CHECK.get(id);
    }
}

