/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.config.util;

import com.google.common.collect.Lists;
import com.imguns.guns.config.sync.SyncConfig;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.StringUtils;

public class InteractKeyConfigRead {
    private static final EnumMap<Type, List<class_2960>> WHITELIST = new EnumMap(Type.class);
    private static final EnumMap<Type, List<class_2960>> BLACKLIST = new EnumMap(Type.class);
    private static final class_6862<class_2248> WHITELIST_BLOCKS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("immersive_guns", "interact_key/whitelist"));
    private static final class_6862<class_2248> BLACKLIST_BLOCKS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("immersive_guns", "interact_key/blacklist"));
    private static final class_6862<class_1299<?>> WHITELIST_ENTITIES = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960("immersive_guns", "interact_key/whitelist"));
    private static final class_6862<class_1299<?>> BLACKLIST_ENTITIES = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)new class_2960("immersive_guns", "interact_key/blacklist"));

    public static void init() {
        WHITELIST.clear();
        BLACKLIST.clear();
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_WHITELIST_BLOCKS.get(), WHITELIST, Type.BLOCK);
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_WHITELIST_ENTITIES.get(), WHITELIST, Type.ENTITY);
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_BLACKLIST_BLOCKS.get(), BLACKLIST, Type.BLOCK);
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_BLACKLIST_ENTITIES.get(), BLACKLIST, Type.ENTITY);
    }

    public static boolean canInteractBlock(class_2680 block) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)block.method_26204());
        if (BLACKLIST.containsKey((Object)Type.BLOCK) && BLACKLIST.get((Object)Type.BLOCK).contains(blockId)) {
            return false;
        }
        if (block.method_26164(BLACKLIST_BLOCKS)) {
            return false;
        }
        if (WHITELIST.containsKey((Object)Type.BLOCK) && WHITELIST.get((Object)Type.BLOCK).contains(blockId)) {
            return true;
        }
        return block.method_26164(WHITELIST_BLOCKS);
    }

    public static boolean canInteractEntity(class_1297 entity) {
        class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
        if (BLACKLIST.containsKey((Object)Type.ENTITY) && BLACKLIST.get((Object)Type.ENTITY).contains(entityId)) {
            return false;
        }
        if (entity.method_5864().method_20210(BLACKLIST_ENTITIES)) {
            return false;
        }
        if (WHITELIST.containsKey((Object)Type.ENTITY) && WHITELIST.get((Object)Type.ENTITY).contains(entityId)) {
            return true;
        }
        return entity.method_5864().method_20210(WHITELIST_ENTITIES);
    }

    private static void handleConfigData(List<String> configData, EnumMap<Type, List<class_2960>> storeList, Type type) {
        configData.forEach(data -> {
            if (data.isEmpty()) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)data)) {
                return;
            }
            class_2960 id = new class_2960(data);
            storeList.computeIfAbsent(type, t -> Lists.newArrayList()).add(id);
        });
    }

    public static enum Type {
        BLOCK,
        ENTITY;

    }
}

