/*
 * Decompiled with CFR 0.152.
 */
package com.imguns.guns.entity;

import com.imguns.guns.api.DefaultAssets;
import com.imguns.guns.api.LogicalSide;
import com.imguns.guns.api.entity.ITargetEntity;
import com.imguns.guns.api.entity.KnockBackModifier;
import com.imguns.guns.api.event.common.EntityHurtByGunEvent;
import com.imguns.guns.api.event.common.EntityKillByGunEvent;
import com.imguns.guns.api.event.server.AmmoHitBlockEvent;
import com.imguns.guns.client.particle.AmmoParticleSpawner;
import com.imguns.guns.config.common.AmmoConfig;
import com.imguns.guns.config.sync.SyncConfig;
import com.imguns.guns.config.util.HeadShotAABBConfigRead;
import com.imguns.guns.init.ModDamageTypes;
import com.imguns.guns.network.NetworkHandler;
import com.imguns.guns.network.message.event.ServerMessageGunHurt;
import com.imguns.guns.network.message.event.ServerMessageGunKill;
import com.imguns.guns.particles.BulletHoleOption;
import com.imguns.guns.resource.pojo.data.gun.BulletData;
import com.imguns.guns.resource.pojo.data.gun.ExplosionData;
import com.imguns.guns.resource.pojo.data.gun.ExtraDamage;
import com.imguns.guns.util.HitboxHelper;
import com.imguns.guns.util.TacHitResult;
import com.imguns.guns.util.block.BlockRayTrace;
import com.imguns.guns.util.block.ProjectileExplosion;
import io.github.fabricators_of_create.porting_lib.entity.IEntityAdditionalSpawnData;
import io.github.fabricators_of_create.porting_lib.entity.PartEntity;
import io.github.fabricators_of_create.porting_lib.entity.PortingLibEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1560;
import net.minecraft.class_1676;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4770;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class EntityKineticBullet
extends class_1676
implements IEntityAdditionalSpawnData {
    public static final class_1299<EntityKineticBullet> TYPE = class_1299.class_1300.method_5903(EntityKineticBullet::new, (class_1311)class_1311.field_17715).method_5901().method_5904().method_19947().method_17687(0.0625f, 0.0625f).method_27299(5).method_27300(5).method_5905("bullet");
    private static final Predicate<class_1297> PROJECTILE_TARGETS = input -> input != null && input.method_5863() && !input.method_7325();
    private class_2960 ammoId = DefaultAssets.EMPTY_AMMO_ID;
    private int life = 200;
    private float speed = 1.0f;
    private float gravity = 0.0f;
    private float friction = 0.01f;
    private float damageAmount = 5.0f;
    private float knockback = 0.0f;
    private boolean hasExplosion = false;
    private boolean hasIgnite = false;
    private int igniteEntityTime = 2;
    private float explosionDamage = 3.0f;
    private float explosionRadius = 3.0f;
    private int explosionDelayCount = Integer.MAX_VALUE;
    private boolean explosionKnockback = false;
    private ExtraDamage extraDamage = null;
    private float damageModifier = 1.0f;
    private int pierce = 1;
    private class_243 startPos;
    private boolean isTracerAmmo;
    private class_243 originCameraPosition;
    private class_243 originRenderOffset;
    private class_2960 gunId;

    public EntityKineticBullet(class_1299<? extends class_1676> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public EntityKineticBullet(class_1299<? extends class_1676> type, double x, double y, double z, class_1937 worldIn) {
        this(type, worldIn);
        this.method_5814(x, y, z);
    }

    public EntityKineticBullet(class_1937 worldIn, class_1309 throwerIn, class_2960 ammoId, class_2960 gunId, boolean isTracerAmmo, BulletData data) {
        this(TYPE, throwerIn.method_23317(), throwerIn.method_23320() - (double)0.1f, throwerIn.method_23321(), worldIn);
        this.method_7432((class_1297)throwerIn);
        this.ammoId = ammoId;
        this.life = class_3532.method_15340((int)((int)(data.getLifeSecond() * 20.0f)), (int)1, (int)Integer.MAX_VALUE);
        this.speed = class_3532.method_15363((float)(data.getSpeed() / 20.0f), (float)0.0f, (float)30.0f);
        this.gravity = class_3532.method_15363((float)data.getGravity(), (float)0.0f, (float)Float.MAX_VALUE);
        this.friction = class_3532.method_15363((float)data.getFriction(), (float)0.0f, (float)Float.MAX_VALUE);
        this.hasIgnite = data.isHasIgnite();
        this.igniteEntityTime = Math.max(data.getIgniteEntityTime(), 0);
        this.damageAmount = (float)class_3532.method_15350((double)((double)data.getDamageAmount() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get()), (double)0.0, (double)Double.MAX_VALUE);
        if (data.getBulletAmount() > 1) {
            this.damageModifier = 1.0f / (float)data.getBulletAmount();
        }
        this.knockback = class_3532.method_15363((float)data.getKnockback(), (float)0.0f, (float)Float.MAX_VALUE);
        this.pierce = class_3532.method_15340((int)data.getPierce(), (int)1, (int)Integer.MAX_VALUE);
        this.extraDamage = data.getExtraDamage();
        ExplosionData explosionData = data.getExplosionData();
        if (explosionData != null) {
            this.hasExplosion = true;
            this.explosionDamage = (float)class_3532.method_15350((double)((double)explosionData.getDamage() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get()), (double)0.0, (double)3.4028234663852886E38);
            this.explosionRadius = class_3532.method_15363((float)explosionData.getRadius(), (float)0.0f, (float)Float.MAX_VALUE);
            this.explosionKnockback = explosionData.isKnockback();
            int delayTickCount = explosionData.getDelay() * 20;
            if (delayTickCount < 0) {
                delayTickCount = Integer.MAX_VALUE;
            }
            this.explosionDelayCount = Math.max(delayTickCount, 1);
        }
        double posX = throwerIn.field_6038 + (throwerIn.method_23317() - throwerIn.field_6038) / 2.0;
        double posY = throwerIn.field_5971 + (throwerIn.method_23318() - throwerIn.field_5971) / 2.0 + (double)throwerIn.method_5751();
        double posZ = throwerIn.field_5989 + (throwerIn.method_23321() - throwerIn.field_5989) / 2.0;
        this.method_5814(posX, posY, posZ);
        this.startPos = this.method_19538();
        this.isTracerAmmo = isTracerAmmo;
        this.gunId = gunId;
    }

    public static void createExplosion(class_1297 owner, class_1297 exploder, float damage, float radius, boolean knockback, class_243 hitPos) {
        class_1937 class_19372 = exploder.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        class_1927.class_4179 mode = class_1927.class_4179.field_40878;
        if (((Boolean)AmmoConfig.EXPLOSIVE_AMMO_DESTROYS_BLOCKS.get()).booleanValue()) {
            mode = class_1927.class_4179.field_18687;
        }
        ProjectileExplosion explosion = new ProjectileExplosion((class_1937)level, owner, exploder, null, null, hitPos.method_10216(), hitPos.method_10214(), hitPos.method_10215(), damage, radius, knockback, mode);
        explosion.method_8348();
        explosion.method_8350(true);
        if (mode == class_1927.class_4179.field_40878) {
            explosion.method_8352();
        }
        level.method_18456().stream().filter(player -> class_3532.method_15355((float)((float)player.method_5707(hitPos))) < (float)((Integer)AmmoConfig.EXPLOSIVE_AMMO_VISIBLE_DISTANCE.get()).intValue()).forEach(player -> {
            class_2664 packet = new class_2664(hitPos.method_10216(), hitPos.method_10214(), hitPos.method_10215(), radius, explosion.method_8346(), (class_243)explosion.method_8351().get(player));
            player.field_13987.method_14364((class_2596)packet);
        });
    }

    protected void method_5693() {
    }

    public void method_5773() {
        super.method_5773();
        this.onBulletTick();
        if (this.method_37908().field_9236) {
            AmmoParticleSpawner.addParticle(this, this.gunId);
        }
        class_243 velocity = this.method_18798();
        double x = velocity.field_1352;
        double y = velocity.field_1351;
        double z = velocity.field_1350;
        double distance = velocity.method_37267();
        this.method_36456((float)Math.toDegrees(class_3532.method_15349((double)x, (double)z)));
        this.method_36457((float)Math.toDegrees(class_3532.method_15349((double)y, (double)distance)));
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        this.method_36457(EntityKineticBullet.method_26960((float)this.field_6004, (float)this.method_36455()));
        this.method_36456(EntityKineticBullet.method_26960((float)this.field_5982, (float)this.method_36454()));
        double nextPosX = this.method_23317() + x;
        double nextPosY = this.method_23318() + y;
        double nextPosZ = this.method_23321() + z;
        this.method_5814(nextPosX, nextPosY, nextPosZ);
        this.method_26962();
        float friction = this.friction;
        float gravity = this.gravity;
        if (this.method_5799()) {
            for (int i = 0; i < 4; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11247, nextPosX - x * 0.25, nextPosY - y * 0.25, nextPosZ - z * 0.25, x, y, z);
            }
            friction = 0.4f;
            gravity *= 0.6f;
        }
        this.method_18799(this.method_18798().method_1021((double)(1.0f - friction)));
        this.method_18799(this.method_18798().method_1031(0.0, (double)(-gravity), 0.0));
        if (this.field_6012 >= this.life - 1) {
            this.method_31472();
        }
    }

    protected void onBulletTick() {
        if (!this.method_37908().method_8608()) {
            if (this.hasExplosion) {
                if (this.explosionDelayCount > 0) {
                    --this.explosionDelayCount;
                } else {
                    EntityKineticBullet.createExplosion(this.method_24921(), (class_1297)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.method_19538());
                    this.method_31472();
                    return;
                }
            }
            class_243 startVec = this.method_19538();
            class_243 endVec = startVec.method_1019(this.method_18798());
            Object result = BlockRayTrace.rayTraceBlocks(this.method_37908(), new class_3959(startVec, endVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            class_3965 resultB = result;
            if (resultB.method_17783() != class_239.class_240.field_1333) {
                endVec = resultB.method_17784();
            }
            List<EntityResult> hitEntities = null;
            if (this.pierce <= 1 || this.hasExplosion) {
                EntityResult entityResult = this.findEntityOnPath(startVec, endVec);
                if (entityResult != null) {
                    hitEntities = Collections.singletonList(entityResult);
                }
            } else {
                hitEntities = this.findEntitiesOnPath(startVec, endVec);
            }
            if (hitEntities != null && !hitEntities.isEmpty()) {
                EntityResult[] hitEntityResult = hitEntities.toArray(new EntityResult[0]);
                for (int i = 0; (i < this.pierce || i < 1) && i < hitEntityResult.length - 1; ++i) {
                    int k = i;
                    for (int j = i + 1; j < hitEntityResult.length; ++j) {
                        if (!(hitEntityResult[j].hitVec.method_1022(startVec) < hitEntityResult[k].hitVec.method_1022(startVec))) continue;
                        k = j;
                    }
                    EntityResult t = hitEntityResult[i];
                    hitEntityResult[i] = hitEntityResult[k];
                    hitEntityResult[k] = t;
                }
                for (EntityResult entityResult : hitEntityResult) {
                    result = new TacHitResult(entityResult);
                    this.onHitEntity((TacHitResult)((Object)result), startVec, endVec);
                    --this.pierce;
                    if (this.pierce >= 1 && !this.hasExplosion) continue;
                    this.method_31472();
                    return;
                }
            }
            this.onHitBlock(resultB, startVec, endVec);
        }
    }

    @Nullable
    protected EntityResult findEntityOnPath(class_243 startVec, class_243 endVec) {
        class_243 hitVec = null;
        class_1297 hitEntity = null;
        boolean headshot = false;
        List entities = this.method_37908().method_8333((class_1297)this, this.method_5829().method_18804(this.method_18798()).method_1014(1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        class_1297 owner = this.method_24921();
        for (class_1297 entity : entities) {
            EntityResult result;
            if (entity.equals((Object)owner) || owner != null && entity.equals((Object)owner.method_5854()) || (result = this.getHitResult(entity, startVec, endVec)) == null) continue;
            class_243 hitPos = result.getHitPos();
            double distanceToHit = startVec.method_1022(hitPos);
            if (!entity.method_5805() || !(distanceToHit < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot) : null;
    }

    @Nullable
    protected List<EntityResult> findEntitiesOnPath(class_243 startVec, class_243 endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.method_37908().method_8333((class_1297)this, this.method_5829().method_18804(this.method_18798()).method_1014(1.0), PROJECTILE_TARGETS);
        class_1297 owner = this.method_24921();
        for (class_1297 entity : entities) {
            EntityResult result;
            if (entity.equals((Object)owner) || owner != null && entity.equals((Object)owner.method_5854()) || (result = this.getHitResult(entity, startVec, endVec)) == null || !entity.method_5805()) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    protected EntityResult getHitResult(class_1297 entity, class_243 startVec, class_243 endVec) {
        class_238 aabb;
        class_238 boundingBox = HitboxHelper.getFixedBoundingBox(entity, this.method_24921());
        class_243 hitPos = boundingBox.method_992(startVec, endVec).orElse(null);
        if (hitPos == null) {
            return null;
        }
        class_243 hitBoxPos = hitPos.method_1020(entity.method_19538());
        class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
        if (entityId != null && (aabb = HeadShotAABBConfigRead.getAABB(entityId)) != null) {
            return new EntityResult(entity, hitPos, aabb.method_1006(hitBoxPos));
        }
        boolean headshot = false;
        float eyeHeight = entity.method_5751();
        if ((double)eyeHeight - 0.25 < hitBoxPos.field_1351 && hitBoxPos.field_1351 < (double)eyeHeight + 0.25) {
            headshot = true;
        }
        return new EntityResult(entity, hitPos, headshot);
    }

    protected void onHitEntity(TacHitResult result, class_243 startVec, class_243 endVec) {
        PartEntity part;
        class_1297 class_12972;
        Object object;
        EntityHurtByGunEvent.Pre preEvent;
        class_1297 class_12973 = result.method_17782();
        if (class_12973 instanceof ITargetEntity) {
            ITargetEntity targetEntity = (ITargetEntity)class_12973;
            class_1282 source = this.method_48923().method_48811((class_1297)this, this.method_24921());
            targetEntity.onProjectileHit((class_1297)this, result, source, this.getDamage(result.method_17784()));
            return;
        }
        class_1297 entity = result.method_17782();
        @Nullable class_1297 owner = this.method_24921();
        class_1309 attacker = owner instanceof class_1309 ? (class_1309)owner : null;
        boolean headshot = result.isHeadshot();
        float damage = this.getDamage(result.method_17784());
        float headShotMultiplier = 1.0f;
        if (this.extraDamage != null && this.extraDamage.getHeadShotMultiplier() > 0.0f) {
            headShotMultiplier = (float)((double)this.extraDamage.getHeadShotMultiplier() * (Double)SyncConfig.HEAD_SHOT_BASE_MULTIPLIER.get());
        }
        if ((preEvent = new EntityHurtByGunEvent.Pre(entity, attacker, this.gunId, damage, headshot, headShotMultiplier, LogicalSide.SERVER)).post()) {
            return;
        }
        entity = preEvent.getHurtEntity();
        if (entity instanceof class_1508) {
            class_1508 part2 = (class_1508)entity;
            object = part2.field_7007;
        } else if (entity instanceof PartEntity && (class_12972 = (part = (PartEntity)entity).getParent()) instanceof class_1309) {
            class_1309 partOwner = (class_1309)class_12972;
            object = partOwner;
        } else {
            object = entity instanceof class_1309 ? (class_1309)entity : null;
        }
        class_1510 livingEntity = object;
        attacker = preEvent.getAttacker();
        class_2960 newGunId = preEvent.getGunId();
        damage = preEvent.getBaseAmount();
        headshot = preEvent.isHeadShot();
        headShotMultiplier = preEvent.getHeadshotMultiplier();
        if (entity == null) {
            return;
        }
        if (this.hasIgnite && ((Boolean)AmmoConfig.IGNITE_ENTITY.get()).booleanValue()) {
            entity.method_5639(this.igniteEntityTime);
        }
        if (headshot) {
            damage *= headShotMultiplier;
        }
        if (livingEntity != null) {
            KnockBackModifier modifier = KnockBackModifier.fromLivingEntity((class_1309)livingEntity);
            modifier.setKnockBackStrength(this.knockback);
            this.tacAttackEntity(entity, damage);
            modifier.resetKnockBackStrength();
        } else {
            this.tacAttackEntity(entity, damage);
        }
        if (this.hasExplosion) {
            entity.field_6008 = 0;
            EntityKineticBullet.createExplosion(this.method_24921(), (class_1297)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, result.method_17784());
        }
        if (livingEntity != null && !this.method_37908().field_9236) {
            int attackerId;
            int n = attackerId = attacker == null ? 0 : attacker.method_5628();
            if (livingEntity.method_29504()) {
                new EntityKillByGunEvent((class_1309)livingEntity, attacker, newGunId, headshot, LogicalSide.SERVER).post();
                NetworkHandler.sendToDimension(new ServerMessageGunKill(livingEntity.method_5628(), attackerId, newGunId, headshot), (class_1297)livingEntity);
            } else {
                new EntityHurtByGunEvent.Post((class_1297)livingEntity, attacker, newGunId, damage, headshot, headShotMultiplier, LogicalSide.SERVER).post();
                NetworkHandler.sendToDimension(new ServerMessageGunHurt(livingEntity.method_5628(), attackerId, newGunId, damage, headshot, headShotMultiplier), (class_1297)livingEntity);
            }
        }
    }

    protected void onHitBlock(class_3965 result, class_243 startVec, class_243 endVec) {
        super.method_24920(result);
        if (result.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        class_243 hitVec = result.method_17784();
        class_2338 pos = result.method_17777();
        if (new AmmoHitBlockEvent(this.method_37908(), result, this.method_37908().method_8320(pos), this).post()) {
            return;
        }
        if (this.hasExplosion) {
            EntityKineticBullet.createExplosion(this.method_24921(), (class_1297)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, hitVec);
            this.method_31472();
            return;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            BulletHoleOption bulletHoleOption = new BulletHoleOption(result.method_17780(), result.method_17777(), this.ammoId.toString(), this.gunId.toString());
            serverLevel.method_14199((class_2394)bulletHoleOption, hitVec.field_1352, hitVec.field_1351, hitVec.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            if (this.hasIgnite) {
                serverLevel.method_14199((class_2394)class_2398.field_11239, hitVec.field_1352, hitVec.field_1351, hitVec.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.hasIgnite && ((Boolean)AmmoConfig.IGNITE_BLOCK.get()).booleanValue()) {
            class_2338 offsetPos = pos.method_10093(result.method_17780());
            if (class_4770.method_30032((class_1937)this.method_37908(), (class_2338)offsetPos, (class_2350)result.method_17780())) {
                class_2680 fireState = class_4770.method_24416((class_1922)this.method_37908(), (class_2338)offsetPos);
                this.method_37908().method_8652(offsetPos, fireState, 11);
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11239, hitVec.field_1352 - 1.0 + this.field_5974.method_43058() * 2.0, hitVec.field_1351, hitVec.field_1350 - 1.0 + this.field_5974.method_43058() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.method_31472();
    }

    public float getDamage(class_243 hitVec) {
        if (this.extraDamage == null) {
            return Math.max(0.0f, this.damageAmount * this.damageModifier);
        }
        LinkedList<ExtraDamage.DistanceDamagePair> damageDecay = this.extraDamage.getDamageAdjust();
        if (damageDecay == null || damageDecay.isEmpty()) {
            return Math.max(0.0f, this.damageAmount * this.damageModifier);
        }
        double playerDistance = hitVec.method_1022(this.startPos);
        for (ExtraDamage.DistanceDamagePair pair : damageDecay) {
            if (!(playerDistance < (double)pair.getDistance())) continue;
            return (float)(Math.max(0.0, (double)pair.getDamage() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get()) * (double)this.damageModifier);
        }
        return 0.0f;
    }

    private void tacAttackEntity(class_1297 entity, float damage) {
        class_1282 source = ModDamageTypes.Sources.bullet(this.method_37908().method_30349(), this, this.method_24921(), false);
        float armorIgnore = 0.0f;
        if (this.extraDamage != null && this.extraDamage.getArmorIgnore() > 0.0f) {
            armorIgnore = (float)((double)this.extraDamage.getArmorIgnore() * (Double)SyncConfig.ARMOR_IGNORE_BASE_MULTIPLIER.get());
        }
        if (entity instanceof class_1560) {
            source = this.method_48923().method_48815((class_1297)this, this.method_24921());
        }
        float armorDamagePercent = class_3532.method_15363((float)armorIgnore, (float)0.0f, (float)1.0f);
        float normalDamagePercent = 1.0f - armorDamagePercent;
        entity.field_6008 = 0;
        entity.method_5643(source, damage * normalDamagePercent);
        source = ModDamageTypes.Sources.bullet(this.method_37908().method_30349(), this, this.method_24921(), true);
        entity.field_6008 = 0;
        entity.method_5643(source, damage * armorDamagePercent);
    }

    public class_2596<class_2602> method_18002() {
        return PortingLibEntity.getEntitySpawningPacket((class_1297)this);
    }

    public void writeSpawnData(class_2540 buf) {
        buf.writeFloat(this.method_36455());
        buf.writeFloat(this.method_36454());
        buf.writeDouble(this.method_18798().field_1352);
        buf.writeDouble(this.method_18798().field_1351);
        buf.writeDouble(this.method_18798().field_1350);
        class_1297 entity = this.method_24921();
        buf.writeInt(entity != null ? entity.method_5628() : 0);
        buf.method_10812(this.ammoId);
        buf.writeFloat(this.gravity);
        buf.writeBoolean(this.hasExplosion);
        buf.writeBoolean(this.hasIgnite);
        buf.writeFloat(this.explosionRadius);
        buf.writeFloat(this.explosionDamage);
        buf.writeInt(this.life);
        buf.writeFloat(this.speed);
        buf.writeFloat(this.friction);
        buf.writeInt(this.pierce);
        buf.writeBoolean(this.isTracerAmmo);
        buf.method_10812(this.gunId);
    }

    public void readSpawnData(class_2540 buf) {
        this.method_36457(buf.readFloat());
        this.method_36456(buf.readFloat());
        this.method_18800(buf.readDouble(), buf.readDouble(), buf.readDouble());
        class_1297 entity = this.method_37908().method_8469(buf.readInt());
        if (entity != null) {
            this.method_7432(entity);
        }
        this.ammoId = buf.method_10810();
        this.gravity = buf.readFloat();
        this.hasExplosion = buf.readBoolean();
        this.hasIgnite = buf.readBoolean();
        this.explosionRadius = buf.readFloat();
        this.explosionDamage = buf.readFloat();
        this.life = buf.readInt();
        this.speed = buf.readFloat();
        this.friction = buf.readFloat();
        this.pierce = buf.readInt();
        this.isTracerAmmo = buf.readBoolean();
        this.gunId = buf.method_10810();
    }

    public class_2960 getAmmoId() {
        return this.ammoId;
    }

    public class_2960 getGunId() {
        return this.gunId;
    }

    public boolean isTracerAmmo() {
        return this.isTracerAmmo;
    }

    public class_5819 getRandom() {
        return this.field_5974;
    }

    public class_243 getOriginCameraPosition() {
        return this.originCameraPosition;
    }

    public void setOriginCameraPosition(class_243 originCameraPosition) {
        this.originCameraPosition = originCameraPosition;
    }

    public class_243 getOriginRenderOffset() {
        return this.originRenderOffset;
    }

    public void setOriginRenderOffset(class_243 originRenderOffset) {
        this.originRenderOffset = originRenderOffset;
    }

    public boolean method_34714(@Nullable class_1297 entity) {
        if (entity == null) {
            return false;
        }
        return super.method_34714(entity);
    }

    public static class EntityResult {
        private final class_1297 entity;
        private final class_243 hitVec;
        private final boolean headshot;

        public EntityResult(class_1297 entity, class_243 hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        public class_1297 getEntity() {
            return this.entity;
        }

        public class_243 getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }
    }
}

